/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moonshot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.moonshot.api.MoonshotApi;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MoonshotChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="tools")
    private List<MoonshotApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonProperty(value="user")
    private String user;
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functionNames) {
        this.functions = functionNames;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public MoonshotChatOptions copy() {
        return MoonshotChatOptions.builder().model(this.model).maxTokens(this.maxTokens).temperature(this.temperature).topP(this.topP).N(this.n).presencePenalty(this.presencePenalty).frequencyPenalty(this.frequencyPenalty).stop(this.stop).user(this.user).tools(this.tools).toolChoice(this.toolChoice).functionCallbacks(this.functionCallbacks).functions(this.functions).proxyToolCalls(this.proxyToolCalls).toolContext(this.toolContext).build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.frequencyPenalty == null ? 0 : this.frequencyPenalty.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.n == null ? 0 : this.n.hashCode());
        result = 31 * result + (this.presencePenalty == null ? 0 : this.presencePenalty.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.proxyToolCalls == null ? 0 : this.proxyToolCalls.hashCode());
        result = 31 * result + (this.toolContext == null ? 0 : this.toolContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoonshotChatOptions other = (MoonshotChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.frequencyPenalty == null ? other.frequencyPenalty != null : !this.frequencyPenalty.equals(other.frequencyPenalty)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.n == null ? other.n != null : !this.n.equals(other.n)) {
            return false;
        }
        if (this.presencePenalty == null ? other.presencePenalty != null : !this.presencePenalty.equals(other.presencePenalty)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.user == null) {
            return other.user == null;
        }
        if (!this.user.equals(other.user)) {
            return false;
        }
        if (this.proxyToolCalls == null) {
            return other.proxyToolCalls == null;
        }
        if (!this.proxyToolCalls.equals(other.proxyToolCalls)) {
            return false;
        }
        if (this.toolContext == null) {
            return other.toolContext == null;
        }
        return this.toolContext.equals(other.toolContext);
    }

    public static class Builder {
        private final MoonshotChatOptions options = new MoonshotChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder tools(List<MoonshotApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder functions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder function(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            if (this.options.functions == null) {
                this.options.functions = new HashSet<String>();
            }
            this.options.functions.add(functionName);
            return this;
        }

        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public MoonshotChatOptions build() {
            return this.options;
        }
    }
}

