/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.qianfan.QianFanEmbeddingOptions;
import org.springframework.ai.qianfan.api.QianFanApi;
import org.springframework.ai.qianfan.api.QianFanConstants;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class QianFanEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final QianFanEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final QianFanApi qianFanApi;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public QianFanEmbeddingModel(QianFanApi qianFanApi) {
        this(qianFanApi, MetadataMode.EMBED);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode) {
        this(qianFanApi, metadataMode, QianFanEmbeddingOptions.builder().model(QianFanApi.DEFAULT_EMBEDDING_MODEL).build());
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode, QianFanEmbeddingOptions qianFanEmbeddingOptions) {
        this(qianFanApi, metadataMode, qianFanEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode, QianFanEmbeddingOptions qianFanEmbeddingOptions, RetryTemplate retryTemplate) {
        this(qianFanApi, metadataMode, qianFanEmbeddingOptions, retryTemplate, ObservationRegistry.NOOP);
    }

    public QianFanEmbeddingModel(QianFanApi qianFanApi, MetadataMode metadataMode, QianFanEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)qianFanApi, (String)"QianFanApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.qianFanApi = qianFanApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        QianFanEmbeddingOptions requestOptions = this.mergeOptions(request.getOptions(), this.defaultOptions);
        QianFanApi.EmbeddingRequest apiRequest = new QianFanApi.EmbeddingRequest(request.getInstructions(), requestOptions.getModel(), requestOptions.getUser());
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(request).provider(QianFanConstants.PROVIDER_NAME).requestOptions((EmbeddingOptions)requestOptions).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            QianFanApi.EmbeddingList apiEmbeddingResponse = (QianFanApi.EmbeddingList)this.retryTemplate.execute(ctx -> (QianFanApi.EmbeddingList)this.qianFanApi.embeddings(apiRequest).getBody());
            if (apiEmbeddingResponse == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            if (apiEmbeddingResponse.errorNsg() != null) {
                logger.error("Error message returned for request: {}", (Object)apiEmbeddingResponse.errorNsg());
                throw new RuntimeException("Embedding failed: error code:" + apiEmbeddingResponse.errorCode() + ", message:" + apiEmbeddingResponse.errorNsg());
            }
            EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata(apiRequest.model(), (Usage)this.getDefaultUsage(apiEmbeddingResponse.usage()));
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    private DefaultUsage getDefaultUsage(QianFanApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private QianFanEmbeddingOptions mergeOptions(@Nullable EmbeddingOptions runtimeOptions, QianFanEmbeddingOptions defaultOptions) {
        QianFanEmbeddingOptions runtimeOptionsForProvider = (QianFanEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, EmbeddingOptions.class, QianFanEmbeddingOptions.class);
        if (runtimeOptionsForProvider == null) {
            return defaultOptions;
        }
        return QianFanEmbeddingOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getModel(), (Object)defaultOptions.getModel())).user((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getUser(), (Object)defaultOptions.getUser())).build();
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

