/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.qianfan;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.observation.DefaultImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.qianfan.QianFanImageOptions;
import org.springframework.ai.qianfan.api.QianFanConstants;
import org.springframework.ai.qianfan.api.QianFanImageApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class QianFanImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanImageModel.class);
    private static final ImageModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultImageModelObservationConvention();
    private final QianFanImageOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final QianFanImageApi qianFanImageApi;
    private final ObservationRegistry observationRegistry;
    private ImageModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public QianFanImageModel(QianFanImageApi qianFanImageApi) {
        this(qianFanImageApi, QianFanImageOptions.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanImageModel(QianFanImageApi qianFanImageApi, QianFanImageOptions options) {
        this(qianFanImageApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanImageModel(QianFanImageApi qianFanImageApi, QianFanImageOptions options, RetryTemplate retryTemplate) {
        this(qianFanImageApi, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public QianFanImageModel(QianFanImageApi qianFanImageApi, QianFanImageOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)qianFanImageApi, (String)"QianFanImageApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.qianFanImageApi = qianFanImageApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        QianFanImageOptions requestImageOptions = this.mergeOptions(imagePrompt.getOptions(), this.defaultOptions);
        QianFanImageApi.QianFanImageRequest imageRequest = this.createRequest(imagePrompt, requestImageOptions);
        ImageModelObservationContext observationContext = ImageModelObservationContext.builder().imagePrompt(imagePrompt).provider(QianFanConstants.PROVIDER_NAME).requestOptions((ImageOptions)requestImageOptions).build();
        return (ImageResponse)ImageModelObservationDocumentation.IMAGE_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity imageResponseEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.qianFanImageApi.createImage(imageRequest));
            ImageResponse imageResponse = this.convertResponse((ResponseEntity<QianFanImageApi.QianFanImageResponse>)imageResponseEntity, imageRequest);
            observationContext.setResponse((Object)imageResponse);
            return imageResponse;
        });
    }

    private QianFanImageApi.QianFanImageRequest createRequest(ImagePrompt imagePrompt, QianFanImageOptions requestImageOptions) {
        String instructions = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
        QianFanImageApi.QianFanImageRequest imageRequest = new QianFanImageApi.QianFanImageRequest(instructions, QianFanImageApi.DEFAULT_IMAGE_MODEL);
        return (QianFanImageApi.QianFanImageRequest)ModelOptionsUtils.merge((Object)requestImageOptions, (Object)imageRequest, QianFanImageApi.QianFanImageRequest.class);
    }

    private ImageResponse convertResponse(ResponseEntity<QianFanImageApi.QianFanImageResponse> imageResponseEntity, QianFanImageApi.QianFanImageRequest qianFanImageRequest) {
        QianFanImageApi.QianFanImageResponse imageApiResponse = (QianFanImageApi.QianFanImageResponse)imageResponseEntity.getBody();
        if (imageApiResponse == null) {
            logger.warn("No image response returned for request: {}", (Object)qianFanImageRequest);
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = imageApiResponse.data().stream().map(entry -> new ImageGeneration(new Image(null, entry.b64Image()))).toList();
        return new ImageResponse(imageGenerationList);
    }

    private QianFanImageOptions mergeOptions(@Nullable ImageOptions runtimeImageOptions, QianFanImageOptions defaultOptions) {
        QianFanImageOptions runtimeOptionsForProvider = (QianFanImageOptions)ModelOptionsUtils.copyToTarget((Object)runtimeImageOptions, ImageOptions.class, QianFanImageOptions.class);
        if (runtimeOptionsForProvider == null) {
            return defaultOptions;
        }
        return QianFanImageOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getModel(), (Object)defaultOptions.getModel())).N((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getN(), (Object)defaultOptions.getN())).model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getModel(), (Object)defaultOptions.getModel())).width((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getWidth(), (Object)defaultOptions.getWidth())).height((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getHeight(), (Object)defaultOptions.getHeight())).style((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getStyle(), (Object)defaultOptions.getStyle())).user((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getUser(), (Object)defaultOptions.getUser())).build();
    }

    public void setObservationConvention(ImageModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

