/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.oracle;

import io.micrometer.observation.ObservationRegistry;
import javax.sql.DataSource;
import org.springframework.ai.autoconfigure.vectorstore.oracle.OracleVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.ai.vectorstore.oracle.OracleVectorStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={OracleVectorStore.class, DataSource.class, JdbcTemplate.class})
@EnableConfigurationProperties(value={OracleVectorStoreProperties.class})
public class OracleVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public OracleVectorStore vectorStore(JdbcTemplate jdbcTemplate, EmbeddingModel embeddingModel, OracleVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((OracleVectorStore.Builder)((OracleVectorStore.Builder)OracleVectorStore.builder((JdbcTemplate)jdbcTemplate, (EmbeddingModel)embeddingModel).tableName(properties.getTableName()).indexType(properties.getIndexType()).distanceType(properties.getDistanceType()).dimensions(properties.getDimensions()).searchAccuracy(properties.getSearchAccuracy()).initializeSchema(properties.isInitializeSchema()).removeExistingVectorStoreTable(properties.isRemoveExistingVectorStoreTable()).forcedNormalization(properties.isForcedNormalization()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy).build();
    }
}

