/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Set;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(stream).writeObject(object);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not serialize object of type: " + object.getClass(), e);
        }
        return stream.toByteArray();
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return SerializationUtils.deserialize(new ObjectInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not deserialize object", e);
        }
    }

    public static Object deserialize(ObjectInputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            return stream.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not deserialize object type", e);
        }
    }

    public static Object deserialize(InputStream inputStream, final Set<String> allowedListPatterns, ClassLoader classLoader) throws IOException {
        Object object;
        ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream(inputStream, classLoader){

            protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
                Class clazz = super.resolveClass(classDesc);
                SerializationUtils.checkAllowedList(clazz, allowedListPatterns);
                return clazz;
            }
        };
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Failed to deserialize object type", ex);
            }
        }
        objectInputStream.close();
        return object;
    }

    public static void checkAllowedList(Class<?> clazz, Set<String> patterns) {
        if (ObjectUtils.isEmpty(patterns)) {
            return;
        }
        if (clazz.isArray() || clazz.isPrimitive() || clazz.equals(String.class) || Number.class.isAssignableFrom(clazz)) {
            return;
        }
        String className = clazz.getName();
        for (String pattern : patterns) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)className)) continue;
            return;
        }
        throw new SecurityException("Attempt to deserialize unauthorized " + clazz);
    }
}

