/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.impl.nio.NioParams;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class RabbitConnectionFactoryBean
extends AbstractFactoryBean<ConnectionFactory> {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_STORE = "keyStore";
    private static final String TRUST_STORE = "trustStore";
    private static final String KEY_STORE_PASS_PHRASE = "keyStore.passPhrase";
    private static final String TRUST_STORE_PASS_PHRASE = "trustStore.passPhrase";
    private static final String KEY_STORE_TYPE = "keyStore.type";
    private static final String TRUST_STORE_TYPE = "trustStore.type";
    private static final String TLS_V1_1 = "TLSv1.1";
    private static final String KEY_STORE_DEFAULT_TYPE = "PKCS12";
    private static final String TRUST_STORE_DEFAULT_TYPE = "JKS";
    protected final ConnectionFactory connectionFactory = new ConnectionFactory();
    private final Properties sslProperties = new Properties();
    private boolean useSSL;
    private Resource sslPropertiesLocation;
    private volatile String keyStore;
    private volatile String trustStore;
    private volatile Resource keyStoreResource;
    private volatile Resource trustStoreResource;
    private volatile String keyStorePassphrase;
    private volatile String trustStorePassphrase;
    private volatile String keyStoreType;
    private volatile String trustStoreType;
    private volatile String sslAlgorithm = "TLSv1.1";
    private volatile boolean sslAlgorithmSet;
    private volatile SecureRandom secureRandom;
    private boolean skipServerCertificateValidation = true;

    public boolean isSkipServerCertificateValidation() {
        return this.skipServerCertificateValidation;
    }

    public void setSkipServerCertificateValidation(boolean skipServerCertificateValidation) {
        this.skipServerCertificateValidation = skipServerCertificateValidation;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    protected boolean isUseSSL() {
        return this.useSSL;
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = sslAlgorithm;
        this.sslAlgorithmSet = true;
    }

    protected String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public void setSslPropertiesLocation(Resource sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    protected Resource getSslPropertiesLocation() {
        return this.sslPropertiesLocation;
    }

    protected String getKeyStore() {
        return this.keyStore == null ? this.sslProperties.getProperty(KEY_STORE) : this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    protected Resource getKeyStoreResource() {
        return this.keyStoreResource;
    }

    public void setKeyStoreResource(Resource keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    protected String getTrustStore() {
        return this.trustStore == null ? this.sslProperties.getProperty(TRUST_STORE) : this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    protected Resource getTrustStoreResource() {
        return this.trustStoreResource;
    }

    public void setTrustStoreResource(Resource trustStoreResource) {
        this.trustStoreResource = trustStoreResource;
    }

    protected String getKeyStorePassphrase() {
        return this.keyStorePassphrase == null ? this.sslProperties.getProperty(KEY_STORE_PASS_PHRASE) : this.keyStorePassphrase;
    }

    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    protected String getTrustStorePassphrase() {
        return this.trustStorePassphrase == null ? this.sslProperties.getProperty(TRUST_STORE_PASS_PHRASE) : this.trustStorePassphrase;
    }

    public void setTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }

    protected String getKeyStoreType() {
        if (this.keyStoreType == null && this.sslProperties.getProperty(KEY_STORE_TYPE) == null) {
            return KEY_STORE_DEFAULT_TYPE;
        }
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        return this.sslProperties.getProperty(KEY_STORE_TYPE);
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    protected String getTrustStoreType() {
        if (this.trustStoreType == null && this.sslProperties.getProperty(TRUST_STORE_TYPE) == null) {
            return TRUST_STORE_DEFAULT_TYPE;
        }
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        return this.sslProperties.getProperty(TRUST_STORE_TYPE);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    protected SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public void setHost(String host) {
        this.connectionFactory.setHost(host);
    }

    public void setPort(int port) {
        this.connectionFactory.setPort(port);
    }

    public void setUsername(String username) {
        this.connectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.connectionFactory.setPassword(password);
    }

    public void setVirtualHost(String virtualHost) {
        this.connectionFactory.setVirtualHost(virtualHost);
    }

    public void setUri(URI uri) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.connectionFactory.setUri(uri);
    }

    public void setUri(String uriString) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.connectionFactory.setUri(uriString);
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.connectionFactory.setRequestedChannelMax(requestedChannelMax);
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.connectionFactory.setRequestedFrameMax(requestedFrameMax);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionFactory.setConnectionTimeout(connectionTimeout);
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.connectionFactory.setRequestedHeartbeat(requestedHeartbeat);
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.connectionFactory.getClientProperties().putAll(clientProperties);
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.connectionFactory.setSaslConfig(saslConfig);
    }

    public void setSocketFactory(SocketFactory factory) {
        this.connectionFactory.setSocketFactory(factory);
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.connectionFactory.setSocketConfigurator(socketConfigurator);
    }

    public void setSharedExecutor(ExecutorService executor) {
        this.connectionFactory.setSharedExecutor(executor);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.connectionFactory.setThreadFactory(threadFactory);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.connectionFactory.setExceptionHandler(exceptionHandler);
    }

    public void setUseNio(boolean useNio) {
        if (useNio) {
            this.connectionFactory.useNio();
        } else {
            this.connectionFactory.useBlockingIo();
        }
    }

    public void setNioParams(NioParams nioParams) {
        this.connectionFactory.setNioParams(nioParams);
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.connectionFactory.setMetricsCollector(metricsCollector);
    }

    public Class<?> getObjectType() {
        return ConnectionFactory.class;
    }

    protected ConnectionFactory createInstance() throws Exception {
        if (this.useSSL) {
            this.setUpSSL();
        }
        return this.connectionFactory;
    }

    protected void setUpSSL() throws Exception {
        if (this.sslPropertiesLocation == null && this.keyStore == null && this.trustStore == null && this.keyStoreResource == null && this.trustStoreResource == null) {
            if (this.skipServerCertificateValidation) {
                if (this.sslAlgorithmSet) {
                    this.connectionFactory.useSslProtocol(this.sslAlgorithm);
                } else {
                    this.connectionFactory.useSslProtocol();
                }
            } else {
                this.useDefaultTrustStoreMechanism();
            }
        } else {
            if (this.sslPropertiesLocation != null) {
                this.sslProperties.load(this.sslPropertiesLocation.getInputStream());
            }
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String keyStoreName = this.getKeyStore();
            String trustStoreName = this.getTrustStore();
            String keyStorePassword = this.getKeyStorePassphrase();
            String trustStorePassword = this.getTrustStorePassphrase();
            String keyStoreType = this.getKeyStoreType();
            String trustStoreType = this.getTrustStoreType();
            char[] keyPassphrase = null;
            if (StringUtils.hasText((String)keyStorePassword)) {
                keyPassphrase = keyStorePassword.toCharArray();
            }
            char[] trustPassphrase = null;
            if (StringUtils.hasText((String)trustStorePassword)) {
                trustPassphrase = trustStorePassword.toCharArray();
            }
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (StringUtils.hasText((String)keyStoreName) || this.keyStoreResource != null) {
                Resource keyStoreResource = this.keyStoreResource != null ? this.keyStoreResource : resolver.getResource(keyStoreName);
                KeyStore ks = KeyStore.getInstance(keyStoreType);
                ks.load(keyStoreResource.getInputStream(), keyPassphrase);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, keyPassphrase);
                keyManagers = kmf.getKeyManagers();
            }
            if (StringUtils.hasText((String)trustStoreName) || this.trustStoreResource != null) {
                Resource trustStoreResource = this.trustStoreResource != null ? this.trustStoreResource : resolver.getResource(trustStoreName);
                KeyStore tks = KeyStore.getInstance(trustStoreType);
                tks.load(trustStoreResource.getInputStream(), trustPassphrase);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(tks);
                trustManagers = tmf.getTrustManagers();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing SSLContext with KM: " + Arrays.toString(keyManagers) + ", TM: " + Arrays.toString(trustManagers) + ", random: " + this.secureRandom));
            }
            SSLContext context = this.createSSLContext();
            context.init(keyManagers, trustManagers, this.secureRandom);
            this.connectionFactory.useSslProtocol(context);
        }
    }

    protected SSLContext createSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance(this.sslAlgorithm);
    }

    private void useDefaultTrustStoreMechanism() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = SSLContext.getInstance(this.sslAlgorithm);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        this.connectionFactory.useSslProtocol(sslContext);
    }
}

