/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class RabbitAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile ConnectionFactory connectionFactory;
    private volatile boolean transactional;

    public boolean isChannelTransacted() {
        return this.transactional;
    }

    public void setChannelTransacted(boolean transactional) {
        this.transactional = transactional;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.connectionFactory, (String)"ConnectionFactory is required");
    }

    protected Connection createConnection() {
        return this.connectionFactory.createConnection();
    }

    @Nullable
    protected Connection getConnection(RabbitResourceHolder holder) {
        return holder.getConnection();
    }

    @Nullable
    protected Channel getChannel(RabbitResourceHolder holder) {
        return holder.getChannel();
    }

    protected RabbitResourceHolder getTransactionalResourceHolder() {
        return ConnectionFactoryUtils.getTransactionalResourceHolder(this.connectionFactory, this.isChannelTransacted());
    }

    protected RuntimeException convertRabbitAccessException(Exception ex) {
        return RabbitExceptionTranslator.convertRabbitAccessException(ex);
    }
}

