/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Arrays;
import java.util.function.Function;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class BaseRabbitListenerContainerFactory<C extends MessageListenerContainer>
implements RabbitListenerContainerFactory<C> {
    private Boolean defaultRequeueRejected;
    private MessagePostProcessor[] beforeSendReplyPostProcessors;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<?> recoveryCallback;
    private Advice[] adviceChain;
    private Function<String, ReplyPostProcessor> replyPostProcessorProvider;

    @Override
    public abstract C createListenerContainer(RabbitListenerEndpoint var1);

    public void setDefaultRequeueRejected(Boolean requeueRejected) {
        this.defaultRequeueRejected = requeueRejected;
    }

    protected Boolean getDefaultRequeueRejected() {
        return this.defaultRequeueRejected;
    }

    public void setBeforeSendReplyPostProcessors(MessagePostProcessor ... postProcessors) {
        Assert.notNull((Object)postProcessors, (String)"'postProcessors' cannot be null");
        Assert.noNullElements((Object[])postProcessors, (String)"'postProcessors' cannot have null elements");
        this.beforeSendReplyPostProcessors = Arrays.copyOf(postProcessors, postProcessors.length);
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setReplyRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setReplyPostProcessorProvider(Function<String, ReplyPostProcessor> replyPostProcessorProvider) {
        this.replyPostProcessorProvider = replyPostProcessorProvider;
    }

    protected void applyCommonOverrides(@Nullable RabbitListenerEndpoint endpoint, C instance) {
        Object iml;
        if (endpoint != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)endpoint.getAutoStartup(), arg_0 -> instance.setAutoStartup(arg_0));
            instance.setListenerId(endpoint.getId());
            endpoint.setupListenerContainer((MessageListenerContainer)instance);
        }
        if ((iml = instance.getMessageListener()) instanceof AbstractAdaptableMessageListener) {
            AbstractAdaptableMessageListener messageListener = (AbstractAdaptableMessageListener)iml;
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.beforeSendReplyPostProcessors, messageListener::setBeforeSendReplyPostProcessors).acceptIfNotNull((Object)this.retryTemplate, messageListener::setRetryTemplate).acceptIfCondition(this.retryTemplate != null && this.recoveryCallback != null, this.recoveryCallback, messageListener::setRecoveryCallback).acceptIfNotNull((Object)this.defaultRequeueRejected, messageListener::setDefaultRequeueRejected);
            if (endpoint != null) {
                JavaUtils.INSTANCE.acceptIfNotNull((Object)endpoint.getReplyPostProcessor(), messageListener::setReplyPostProcessor).acceptIfNotNull((Object)endpoint.getReplyContentType(), messageListener::setReplyContentType);
                messageListener.setConverterWinsContentType(endpoint.isConverterWinsContentType());
                if (endpoint.getReplyPostProcessor() == null && this.replyPostProcessorProvider != null) {
                    JavaUtils.INSTANCE.acceptIfNotNull((Object)this.replyPostProcessorProvider.apply(endpoint.getId()), messageListener::setReplyPostProcessor);
                }
            }
        }
    }

    @Nullable
    public Advice[] getAdviceChain() {
        return this.adviceChain == null ? null : Arrays.copyOf(this.adviceChain, this.adviceChain.length);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain == null ? null : Arrays.copyOf(adviceChain, adviceChain.length);
    }
}

