/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.impl.NetworkConnection;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Nullable;
import org.springframework.amqp.AmqpResourceNotAvailableException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.rabbit.connection.AutoRecoverConnectionNotCurrentlyOpenException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.backoff.BackOffExecution;

public class SimpleConnection
implements Connection,
NetworkConnection {
    private final com.rabbitmq.client.Connection delegate;
    private final int closeTimeout;
    private volatile boolean explicitlyClosed;
    @Nullable
    private final BackOffExecution backOffExecution;

    public SimpleConnection(com.rabbitmq.client.Connection delegate, int closeTimeout) {
        this(delegate, closeTimeout, null);
    }

    public SimpleConnection(com.rabbitmq.client.Connection delegate, int closeTimeout, @Nullable BackOffExecution backOffExecution) {
        this.delegate = delegate;
        this.closeTimeout = closeTimeout;
        this.backOffExecution = backOffExecution;
    }

    @Override
    public Channel createChannel(boolean transactional) {
        try {
            long interval;
            Channel channel = this.delegate.createChannel();
            while (channel == null && this.backOffExecution != null && (interval = this.backOffExecution.nextBackOff()) != -1L) {
                Thread.sleep(interval);
                channel = this.delegate.createChannel();
            }
            if (channel == null) {
                throw new AmqpResourceNotAvailableException("The channelMax limit is reached. Try later.");
            }
            if (transactional) {
                channel.txSelect();
            }
            return channel;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmqpTimeoutException("Interrupted while creating a new channel", (Throwable)e);
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.explicitlyClosed = true;
            this.delegate.close(this.closeTimeout);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public boolean isOpen() {
        if (!this.explicitlyClosed && this.delegate instanceof AutorecoveringConnection && !this.delegate.isOpen()) {
            throw new AutoRecoverConnectionNotCurrentlyOpenException("Auto recovery connection is not currently open");
        }
        return this.delegate != null && this.delegate.isOpen();
    }

    @Override
    public int getLocalPort() {
        com.rabbitmq.client.Connection connection = this.delegate;
        if (connection instanceof NetworkConnection) {
            NetworkConnection networkConn = (NetworkConnection)connection;
            return networkConn.getLocalPort();
        }
        return 0;
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.delegate.addBlockedListener(listener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        return this.delegate.removeBlockedListener(listener);
    }

    public InetAddress getLocalAddress() {
        com.rabbitmq.client.Connection connection = this.delegate;
        if (connection instanceof NetworkConnection) {
            NetworkConnection networkConn = (NetworkConnection)connection;
            return networkConn.getLocalAddress();
        }
        return null;
    }

    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public com.rabbitmq.client.Connection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "SimpleConnection@" + ObjectUtils.getIdentityHexString((Object)this) + " [delegate=" + this.delegate + ", localPort=" + this.getLocalPort() + "]";
    }
}

