/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.config.RabbitNamespaceUtils;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ListenerContainerParser
implements BeanDefinitionParser {
    private static final String LISTENER_ELEMENT = "listener";
    private static final String ID_ATTRIBUTE = "id";
    private static final String GROUP_ATTRIBUTE = "group";
    private static final String QUEUE_NAMES_ATTRIBUTE = "queue-names";
    private static final String QUEUES_ATTRIBUTE = "queues";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String RESPONSE_EXCHANGE_ATTRIBUTE = "response-exchange";
    private static final String RESPONSE_ROUTING_KEY_ATTRIBUTE = "response-routing-key";
    private static final String EXCLUSIVE = "exclusive";

    ListenerContainerParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        String group = element.getAttribute(GROUP_ATTRIBUTE);
        ManagedList containerList = null;
        if (StringUtils.hasText((String)group)) {
            BeanDefinition groupDef;
            if (parserContext.getRegistry().containsBeanDefinition(group)) {
                groupDef = parserContext.getRegistry().getBeanDefinition(group);
            } else {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ArrayList.class);
                builder.addConstructorArgValue((Object)new ManagedList());
                groupDef = builder.getBeanDefinition();
                BeanDefinitionHolder holder = new BeanDefinitionHolder(groupDef, group);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            }
            ConstructorArgumentValues constructorArgumentValues = groupDef.getConstructorArgumentValues();
            if (!ArrayList.class.getName().equals(groupDef.getBeanClassName()) || constructorArgumentValues.getArgumentCount() != 1 || constructorArgumentValues.getIndexedArgumentValue(0, ManagedList.class) == null) {
                parserContext.getReaderContext().error("Unexpected configuration for bean " + group, (Object)element);
            }
            containerList = (ManagedList)constructorArgumentValues.getIndexedArgumentValue(0, ManagedList.class).getValue();
        }
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)LISTENER_ELEMENT);
        for (int i = 0; i < childElements.size(); ++i) {
            this.parseListener((Element)childElements.get(i), element, parserContext, containerList);
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void parseListener(Element listenerEle, Element containerEle, ParserContext parserContext, ManagedList<RuntimeBeanReference> containerList) {
        String admin;
        String queues;
        String queueNames;
        String childElementId;
        String containerBeanName;
        RootBeanDefinition listenerDef = new RootBeanDefinition();
        listenerDef.setSource(parserContext.extractSource((Object)listenerEle));
        String ref = listenerEle.getAttribute(REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)ref)) {
            parserContext.getReaderContext().error("Listener 'ref' attribute contains empty value.", (Object)listenerEle);
        } else {
            listenerDef.getPropertyValues().add("delegate", (Object)new RuntimeBeanReference(ref));
        }
        String method = null;
        if (listenerEle.hasAttribute(METHOD_ATTRIBUTE) && !StringUtils.hasText((String)(method = listenerEle.getAttribute(METHOD_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener 'method' attribute contains empty value.", (Object)listenerEle);
        }
        listenerDef.getPropertyValues().add("defaultListenerMethod", (Object)method);
        if (containerEle.hasAttribute(MESSAGE_CONVERTER_ATTRIBUTE)) {
            String messageConverter = containerEle.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
            if (!StringUtils.hasText((String)messageConverter)) {
                parserContext.getReaderContext().error("Listener container 'message-converter' attribute contains empty value.", (Object)containerEle);
            } else {
                listenerDef.getPropertyValues().add("messageConverter", (Object)new RuntimeBeanReference(messageConverter));
            }
        }
        BeanDefinition containerDef = RabbitNamespaceUtils.parseContainer(containerEle, parserContext);
        if (listenerEle.hasAttribute(RESPONSE_EXCHANGE_ATTRIBUTE)) {
            String responseExchange = listenerEle.getAttribute(RESPONSE_EXCHANGE_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseExchange", (Object)responseExchange);
        }
        if (listenerEle.hasAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE)) {
            String responseRoutingKey = listenerEle.getAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseRoutingKey", (Object)responseRoutingKey);
        }
        listenerDef.setBeanClass(MessageListenerAdapter.class);
        containerDef.getPropertyValues().add("messageListener", (Object)listenerDef);
        String exclusive = listenerEle.getAttribute(EXCLUSIVE);
        if (StringUtils.hasText((String)exclusive)) {
            containerDef.getPropertyValues().add(EXCLUSIVE, (Object)exclusive);
        }
        String string = containerBeanName = StringUtils.hasText((String)(childElementId = listenerEle.getAttribute(ID_ATTRIBUTE))) ? childElementId : BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)containerDef, (BeanDefinitionRegistry)parserContext.getRegistry());
        if (!NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && !NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided.", (Object)listenerEle);
        }
        if (NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided but not both.", (Object)listenerEle);
        }
        if (StringUtils.hasText((String)(queueNames = listenerEle.getAttribute(QUEUE_NAMES_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("queueNames", (Object)queueNames);
        }
        if (StringUtils.hasText((String)(queues = listenerEle.getAttribute(QUEUES_ATTRIBUTE)))) {
            if (queues.startsWith("#{")) {
                containerDef.getPropertyValues().add(QUEUES_ATTRIBUTE, (Object)queues);
            } else {
                String[] names = StringUtils.commaDelimitedListToStringArray((String)queues);
                ManagedList values = new ManagedList();
                for (int i = 0; i < names.length; ++i) {
                    values.add(new RuntimeBeanReference(names[i].trim()));
                }
                containerDef.getPropertyValues().add(QUEUES_ATTRIBUTE, (Object)values);
            }
        }
        ManagedMap args = new ManagedMap();
        String priority = listenerEle.getAttribute("priority");
        if (StringUtils.hasText((String)priority)) {
            args.put((Object)"x-priority", (Object)new TypedStringValue(priority, Integer.class));
        }
        if (args.size() > 0) {
            containerDef.getPropertyValues().add("consumerArguments", (Object)args);
        }
        if (StringUtils.hasText((String)(admin = listenerEle.getAttribute("admin")))) {
            containerDef.getPropertyValues().add("rabbitAdmin", (Object)new RuntimeBeanReference(admin));
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition(containerDef, containerBeanName));
        if (containerList != null) {
            containerList.add((Object)new RuntimeBeanReference(containerBeanName));
        }
    }
}

