/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.couchbase.CouchbaseReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnClass(value={Cluster.class, Flux.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={CouchbaseAutoConfiguration.class})
public class CouchbaseReactiveHealthIndicatorAutoConfiguration
extends CompositeReactiveHealthIndicatorConfiguration<CouchbaseReactiveHealthIndicator, Cluster> {
    private final Map<String, Cluster> clusters;

    public CouchbaseReactiveHealthIndicatorAutoConfiguration(Map<String, Cluster> clusters) {
        this.clusters = clusters;
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseReactiveHealthIndicator"})
    public ReactiveHealthIndicator couchbaseReactiveHealthIndicator() {
        return this.createHealthIndicator(this.clusters);
    }

    @Override
    protected CouchbaseReactiveHealthIndicator createHealthIndicator(Cluster cluster) {
        return new CouchbaseReactiveHealthIndicator(cluster);
    }
}

