/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class DataSourcePoolMetricsAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={HikariDataSource.class})
    static class HikariDataSourceMetricsConfiguration {
        private static final Log logger = LogFactory.getLog(HikariDataSourceMetricsConfiguration.class);
        private final MeterRegistry registry;

        HikariDataSourceMetricsConfiguration(MeterRegistry registry) {
            this.registry = registry;
        }

        @Autowired
        public void bindMetricsRegistryToHikariDataSources(Collection<DataSource> dataSources) {
            dataSources.stream().filter(HikariDataSource.class::isInstance).map(HikariDataSource.class::cast).forEach(this::bindMetricsRegistryToHikariDataSource);
        }

        private void bindMetricsRegistryToHikariDataSource(HikariDataSource hikari) {
            if (hikari.getMetricRegistry() == null && hikari.getMetricsTrackerFactory() == null) {
                try {
                    hikari.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(this.registry));
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to bind Hikari metrics: " + ex.getMessage()));
                }
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={DataSourcePoolMetadataProvider.class})
    static class DataSourcePoolMetadataMetricsConfiguration {
        private static final String DATASOURCE_SUFFIX = "dataSource";
        private final MeterRegistry registry;
        private final Collection<DataSourcePoolMetadataProvider> metadataProviders;

        DataSourcePoolMetadataMetricsConfiguration(MeterRegistry registry, Collection<DataSourcePoolMetadataProvider> metadataProviders) {
            this.registry = registry;
            this.metadataProviders = metadataProviders;
        }

        @Autowired
        public void bindDataSourcesToRegistry(Map<String, DataSource> dataSources) {
            dataSources.forEach(this::bindDataSourceToRegistry);
        }

        private void bindDataSourceToRegistry(String beanName, DataSource dataSource) {
            String dataSourceName = this.getDataSourceName(beanName);
            new DataSourcePoolMetrics(dataSource, this.metadataProviders, dataSourceName, Collections.emptyList()).bindTo(this.registry);
        }

        private String getDataSourceName(String beanName) {
            if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
                return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
            }
            return beanName;
        }
    }
}

