/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorRegistryBeans;
import org.springframework.boot.actuate.health.ApplicationHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistryFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration
@EnableConfigurationProperties(value={HealthIndicatorProperties.class})
public class HealthIndicatorAutoConfiguration {
    private final HealthIndicatorProperties properties;

    public HealthIndicatorAutoConfiguration(HealthIndicatorProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthIndicator.class, ReactiveHealthIndicator.class})
    public ApplicationHealthIndicator applicationHealthIndicator() {
        return new ApplicationHealthIndicator();
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthAggregator.class})
    public OrderedHealthAggregator healthAggregator() {
        OrderedHealthAggregator healthAggregator = new OrderedHealthAggregator();
        if (this.properties.getOrder() != null) {
            healthAggregator.setStatusOrder(this.properties.getOrder());
        }
        return healthAggregator;
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthIndicatorRegistry.class})
    public HealthIndicatorRegistry healthIndicatorRegistry(ApplicationContext applicationContext) {
        return HealthIndicatorRegistryBeans.get(applicationContext);
    }

    @Configuration
    @ConditionalOnClass(value={Flux.class})
    static class ReactiveHealthIndicatorConfiguration {
        ReactiveHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ReactiveHealthIndicatorRegistry reactiveHealthIndicatorRegistry(ObjectProvider<Map<String, ReactiveHealthIndicator>> reactiveHealthIndicators, ObjectProvider<Map<String, HealthIndicator>> healthIndicators) {
            return new ReactiveHealthIndicatorRegistryFactory().createReactiveHealthIndicatorRegistry((Map)reactiveHealthIndicators.getIfAvailable(Collections::emptyMap), (Map)healthIndicators.getIfAvailable(Collections::emptyMap));
        }
    }
}

