/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.security.servlet.RequestMatcherProvider;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class EndpointRequest {
    private static final RequestMatcher EMPTY_MATCHER = request -> false;

    private EndpointRequest() {
    }

    public static EndpointRequestMatcher toAnyEndpoint() {
        return new EndpointRequestMatcher(true);
    }

    public static EndpointRequestMatcher to(Class<?> ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static EndpointRequestMatcher to(String ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static LinksRequestMatcher toLinks() {
        return new LinksRequestMatcher();
    }

    private static class RequestMatcherFactory {
        private RequestMatcherFactory() {
        }

        public RequestMatcher antPath(RequestMatcherProvider matcherProvider, String ... parts) {
            StringBuilder pattern = new StringBuilder();
            for (String part : parts) {
                pattern.append(part);
            }
            return matcherProvider.getRequestMatcher(pattern.toString());
        }
    }

    public static final class LinksRequestMatcher
    extends AbstractRequestMatcher {
        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            WebEndpointProperties properties = (WebEndpointProperties)context.getBean(WebEndpointProperties.class);
            String basePath = properties.getBasePath();
            if (StringUtils.hasText((String)basePath)) {
                return new OrRequestMatcher(this.getLinksMatchers(requestMatcherFactory, this.getRequestMatcherProvider(context), basePath));
            }
            return EMPTY_MATCHER;
        }
    }

    public static final class EndpointRequestMatcher
    extends AbstractRequestMatcher {
        private final List<Object> includes;
        private final List<Object> excludes;
        private final boolean includeLinks;

        private EndpointRequestMatcher(boolean includeLinks) {
            this(Collections.emptyList(), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(Class<?>[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(String[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointRequestMatcher(List<Object> includes, List<Object> excludes, boolean includeLinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.includeLinks = includeLinks;
        }

        public EndpointRequestMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointRequestMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointRequestMatcher excludingLinks() {
            return new EndpointRequestMatcher(this.includes, this.excludes, false);
        }

        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            PathMappedEndpoints pathMappedEndpoints = (PathMappedEndpoints)context.getBean(PathMappedEndpoints.class);
            RequestMatcherProvider matcherProvider = this.getRequestMatcherProvider(context);
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(pathMappedEndpoints.getAllPaths());
            }
            this.streamPaths(this.includes, pathMappedEndpoints).forEach(paths::add);
            this.streamPaths(this.excludes, pathMappedEndpoints).forEach(paths::remove);
            List<RequestMatcher> delegateMatchers = this.getDelegateMatchers(requestMatcherFactory, matcherProvider, paths);
            String basePath = pathMappedEndpoints.getBasePath();
            if (this.includeLinks && StringUtils.hasText((String)basePath)) {
                delegateMatchers.addAll(this.getLinksMatchers(requestMatcherFactory, matcherProvider, basePath));
            }
            return new OrRequestMatcher(delegateMatchers);
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints pathMappedEndpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)pathMappedEndpoints).getPath(arg_0));
        }

        private EndpointId getEndpointId(Object source) {
            if (source instanceof EndpointId) {
                return (EndpointId)source;
            }
            if (source instanceof String) {
                return EndpointId.of((String)((String)source));
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private EndpointId getEndpointId(Class<?> source) {
            Endpoint annotation = (Endpoint)AnnotatedElementUtils.getMergedAnnotation(source, Endpoint.class);
            Assert.state((annotation != null ? 1 : 0) != 0, () -> "Class " + source + " is not annotated with @Endpoint");
            return EndpointId.of((String)annotation.id());
        }

        private List<RequestMatcher> getDelegateMatchers(RequestMatcherFactory requestMatcherFactory, RequestMatcherProvider matcherProvider, Set<String> paths) {
            return paths.stream().map(path -> requestMatcherFactory.antPath(matcherProvider, (String)path, "/**")).collect(Collectors.toList());
        }
    }

    private static abstract class AbstractRequestMatcher
    extends ApplicationContextRequestMatcher<WebApplicationContext> {
        private volatile RequestMatcher delegate;

        AbstractRequestMatcher() {
            super(WebApplicationContext.class);
        }

        protected final void initialized(Supplier<WebApplicationContext> context) {
            this.delegate = this.createDelegate(context.get());
        }

        protected final boolean matches(HttpServletRequest request, Supplier<WebApplicationContext> context) {
            WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
            if (ManagementPortType.get(applicationContext.getEnvironment()) == ManagementPortType.DIFFERENT) {
                if (applicationContext.getParent() == null) {
                    return false;
                }
                String managementContextId = applicationContext.getParent().getId() + ":management";
                if (!managementContextId.equals(applicationContext.getId())) {
                    return false;
                }
            }
            return this.delegate.matches(request);
        }

        private RequestMatcher createDelegate(WebApplicationContext context) {
            try {
                return this.createDelegate(context, new RequestMatcherFactory());
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        protected abstract RequestMatcher createDelegate(WebApplicationContext var1, RequestMatcherFactory var2);

        protected List<RequestMatcher> getLinksMatchers(RequestMatcherFactory requestMatcherFactory, RequestMatcherProvider matcherProvider, String basePath) {
            ArrayList<RequestMatcher> linksMatchers = new ArrayList<RequestMatcher>();
            linksMatchers.add(requestMatcherFactory.antPath(matcherProvider, basePath));
            linksMatchers.add(requestMatcherFactory.antPath(matcherProvider, basePath, "/"));
            return linksMatchers;
        }

        protected RequestMatcherProvider getRequestMatcherProvider(WebApplicationContext context) {
            try {
                return (RequestMatcherProvider)context.getBean(RequestMatcherProvider.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return AntPathRequestMatcher::new;
            }
        }
    }
}

