/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import java.util.Map;
import org.elasticsearch.client.RestClient;
import org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchClientHealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchRestHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.rest.RestClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestClient.class})
@ConditionalOnBean(value={RestClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={RestClientAutoConfiguration.class, ElasticSearchClientHealthIndicatorAutoConfiguration.class})
public class ElasticSearchRestHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<ElasticsearchRestHealthIndicator, RestClient> {
    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchRestHealthIndicator"})
    public HealthIndicator elasticsearchRestHealthIndicator(Map<String, RestClient> clients) {
        return this.createHealthIndicator(clients);
    }

    @Override
    protected ElasticsearchRestHealthIndicator createHealthIndicator(RestClient client) {
        return new ElasticsearchRestHealthIndicator(client);
    }
}

