/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.solr;

import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.solr.SolrHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SolrClient.class})
@ConditionalOnBean(value={SolrClient.class})
@ConditionalOnEnabledHealthIndicator(value="solr")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={SolrAutoConfiguration.class})
public class SolrHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<SolrHealthIndicator, SolrClient> {
    @Bean
    @ConditionalOnMissingBean(name={"solrHealthIndicator"})
    public HealthIndicator solrHealthIndicator(Map<String, SolrClient> solrClients) {
        return this.createHealthIndicator(solrClients);
    }
}

