/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.redis;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.redis.RedisReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, Flux.class})
@ConditionalOnBean(value={ReactiveRedisConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="redis")
@AutoConfigureAfter(value={RedisReactiveAutoConfiguration.class})
public class RedisReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<RedisReactiveHealthIndicator, ReactiveRedisConnectionFactory> {
    private final Map<String, ReactiveRedisConnectionFactory> redisConnectionFactories;

    RedisReactiveHealthContributorAutoConfiguration(Map<String, ReactiveRedisConnectionFactory> redisConnectionFactories) {
        this.redisConnectionFactories = redisConnectionFactories;
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisReactiveHealthIndicator", "redisReactiveHealthContributor"})
    public ReactiveHealthContributor redisReactiveHealthContributor() {
        return (ReactiveHealthContributor)this.createContributor(this.redisConnectionFactories);
    }
}

