/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.jetty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.metrics.web.jetty.JettyServerThreadPoolMetricsBinder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={JettyServerThreadPoolMetrics.class, Server.class})
@AutoConfigureAfter(value={CompositeMeterRegistryAutoConfiguration.class})
public class JettyMetricsAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={JettyServerThreadPoolMetrics.class, JettyServerThreadPoolMetricsBinder.class})
    public JettyServerThreadPoolMetricsBinder jettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry) {
        return new JettyServerThreadPoolMetricsBinder(meterRegistry);
    }
}

