/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.metrics.AutoTimeProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.ServiceLevelObjectiveBoundary;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private boolean useGlobalRegistry = true;
    private final Map<String, Boolean> enable = new LinkedHashMap<String, Boolean>();
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Web web = new Web();
    private final Data data = new Data();
    private final System system = new System();
    private final Distribution distribution = new Distribution();

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Map<String, Boolean> getEnable() {
        return this.enable;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Web getWeb() {
        return this.web;
    }

    public Data getData() {
        return this.data;
    }

    public System getSystem() {
        return this.system;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Web {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Client {
            private int maxUriTags = 100;

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }

        public static class Server {
            private int maxUriTags = 100;

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }
    }

    public static class Data {
        private final Repository repository = new Repository();

        public Repository getRepository() {
            return this.repository;
        }

        public static class Repository {
            private String metricName = "spring.data.repository.invocations";
            @NestedConfigurationProperty
            private final AutoTimeProperties autotime = new AutoTimeProperties();

            public String getMetricName() {
                return this.metricName;
            }

            public void setMetricName(String metricName) {
                this.metricName = metricName;
            }

            public AutoTimeProperties getAutotime() {
                return this.autotime;
            }
        }
    }

    public static class System {
        private final Diskspace diskspace = new Diskspace();

        public Diskspace getDiskspace() {
            return this.diskspace;
        }

        public static class Diskspace {
            private List<File> paths = new ArrayList<File>(Collections.singletonList(new File(".")));

            public List<File> getPaths() {
                return this.paths;
            }

            public void setPaths(List<File> paths) {
                this.paths = paths;
            }
        }
    }

    public static class Distribution {
        private final Map<String, Boolean> percentilesHistogram = new LinkedHashMap<String, Boolean>();
        private final Map<String, double[]> percentiles = new LinkedHashMap<String, double[]>();
        private final Map<String, ServiceLevelObjectiveBoundary[]> slo = new LinkedHashMap<String, ServiceLevelObjectiveBoundary[]>();
        private final Map<String, String> minimumExpectedValue = new LinkedHashMap<String, String>();
        private final Map<String, String> maximumExpectedValue = new LinkedHashMap<String, String>();
        private final Map<String, Duration> expiry = new LinkedHashMap<String, Duration>();
        private final Map<String, Integer> bufferLength = new LinkedHashMap<String, Integer>();

        public Map<String, Boolean> getPercentilesHistogram() {
            return this.percentilesHistogram;
        }

        public Map<String, double[]> getPercentiles() {
            return this.percentiles;
        }

        public Map<String, ServiceLevelObjectiveBoundary[]> getSlo() {
            return this.slo;
        }

        public Map<String, String> getMinimumExpectedValue() {
            return this.minimumExpectedValue;
        }

        public Map<String, String> getMaximumExpectedValue() {
            return this.maximumExpectedValue;
        }

        public Map<String, Duration> getExpiry() {
            return this.expiry;
        }

        public Map<String, Integer> getBufferLength() {
            return this.bufferLength;
        }
    }
}

