/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import org.springframework.lang.UsesJava8;

@UsesJava8
public class BufferGaugeService
implements GaugeService {
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();
    private final GaugeBuffers buffers;

    public BufferGaugeService(GaugeBuffers buffers) {
        this.buffers = buffers;
    }

    @Override
    public void submit(String metricName, double value) {
        this.buffers.set(this.wrap(metricName), value);
    }

    private String wrap(String metricName) {
        if (this.names.containsKey(metricName)) {
            return this.names.get(metricName);
        }
        if (metricName.startsWith("gauge") || metricName.startsWith("histogram") || metricName.startsWith("timer")) {
            return metricName;
        }
        String name = "gauge." + metricName;
        this.names.put(metricName, name);
        return name;
    }
}

