/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="endpoints")
public class EndpointProperties {
    private static final String ENDPOINTS_ENABLED_PROPERTY = "endpoints.enabled";
    private static final String ENDPOINTS_SENSITIVE_PROPERTY = "endpoints.sensitive";
    private Boolean enabled = true;
    private Boolean sensitive;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public static boolean isEnabled(Environment environment, Boolean enabled) {
        if (enabled != null) {
            return enabled;
        }
        if (environment != null && environment.containsProperty(ENDPOINTS_ENABLED_PROPERTY)) {
            return (Boolean)environment.getProperty(ENDPOINTS_ENABLED_PROPERTY, Boolean.class);
        }
        return true;
    }

    public static boolean isSensitive(Environment environment, Boolean sensitive, boolean sensitiveDefault) {
        if (sensitive != null) {
            return sensitive;
        }
        if (environment != null && environment.containsProperty(ENDPOINTS_SENSITIVE_PROPERTY)) {
            return (Boolean)environment.getProperty(ENDPOINTS_SENSITIVE_PROPERTY, Boolean.class);
        }
        return sensitiveDefault;
    }
}

