/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;

@ConfigurationProperties(value="endpoints.docs")
public class DocsMvcEndpoint
extends AbstractMvcEndpoint {
    private static final String DOCS_LOCATION = "classpath:/META-INF/resources/spring-boot-actuator/docs/";
    private final ManagementServletContext managementServletContext;
    private Curies curies = new Curies();

    public Curies getCuries() {
        return this.curies;
    }

    public DocsMvcEndpoint(ManagementServletContext managementServletContext) {
        super("/docs", false);
        this.managementServletContext = managementServletContext;
    }

    @RequestMapping(value={"/"}, produces={"text/html"})
    public String browse() {
        return "forward:" + this.managementServletContext.getContextPath() + this.getPath() + "/index.html";
    }

    @RequestMapping(value={""}, produces={"text/html"})
    public String redirect() {
        return "redirect:" + this.managementServletContext.getContextPath() + this.getPath() + "/";
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.managementServletContext.getContextPath() + this.getPath() + "/**"}).addResourceLocations(new String[]{DOCS_LOCATION});
    }

    public static class Curies {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

