/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(value="endpoints.actuator")
public class HalJsonMvcEndpoint
extends AbstractMvcEndpoint {
    private final ManagementServletContext managementServletContext;

    public HalJsonMvcEndpoint(ManagementServletContext managementServletContext) {
        super(HalJsonMvcEndpoint.getDefaultPath(managementServletContext), false);
        this.managementServletContext = managementServletContext;
    }

    private static String getDefaultPath(ManagementServletContext managementServletContext) {
        if (StringUtils.hasText((String)managementServletContext.getContextPath())) {
            return "";
        }
        return "/actuator";
    }

    @RequestMapping(produces={"application/json"})
    @ResponseBody
    public ResourceSupport links() {
        return new ResourceSupport();
    }

    protected final ManagementServletContext getManagementServletContext() {
        return this.managementServletContext;
    }
}

