/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.rich;

import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeRepository;
import org.springframework.boot.actuate.metrics.util.SimpleInMemoryRepository;
import org.springframework.boot.actuate.metrics.writer.Delta;

public class InMemoryRichGaugeRepository
implements RichGaugeRepository {
    private final SimpleInMemoryRepository<RichGauge> repository = new SimpleInMemoryRepository();

    @Override
    public void increment(Delta<?> delta) {
    }

    @Override
    public void set(Metric<?> metric) {
        final String name = metric.getName();
        final double value = ((Number)metric.getValue()).doubleValue();
        this.repository.update(name, new SimpleInMemoryRepository.Callback<RichGauge>(){

            @Override
            public RichGauge modify(RichGauge current) {
                if (current == null) {
                    current = new RichGauge(name, value);
                } else {
                    current.set(value);
                }
                return current;
            }
        });
    }

    @Override
    public void reset(String metricName) {
        this.repository.remove(metricName);
    }

    @Override
    public RichGauge findOne(String metricName) {
        return this.repository.findOne(metricName);
    }

    @Override
    public Iterable<RichGauge> findAll() {
        return this.repository.findAll();
    }

    @Override
    public long count() {
        return this.repository.count();
    }
}

