/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.context.ApplicationContext;

public class DataSourcePublicMetrics
implements PublicMetrics {
    private static final String DATASOURCE_SUFFIX = "dataSource";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Collection<DataSourcePoolMetadataProvider> providers;
    private final Map<String, DataSourcePoolMetadata> metadataByPrefix = new HashMap<String, DataSourcePoolMetadata>();

    @PostConstruct
    public void initialize() {
        DataSource primaryDataSource = this.getPrimaryDataSource();
        DataSourcePoolMetadataProviders provider = new DataSourcePoolMetadataProviders(this.providers);
        for (Map.Entry entry : this.applicationContext.getBeansOfType(DataSource.class).entrySet()) {
            String beanName = (String)entry.getKey();
            DataSource bean = (DataSource)entry.getValue();
            String prefix = this.createPrefix(beanName, bean, bean.equals(primaryDataSource));
            DataSourcePoolMetadata poolMetadata = provider.getDataSourcePoolMetadata(bean);
            if (poolMetadata == null) continue;
            this.metadataByPrefix.put(prefix, poolMetadata);
        }
    }

    @Override
    public Collection<Metric<?>> metrics() {
        LinkedHashSet metrics = new LinkedHashSet();
        for (Map.Entry<String, DataSourcePoolMetadata> entry : this.metadataByPrefix.entrySet()) {
            String prefix = entry.getKey();
            prefix = prefix.endsWith(".") ? prefix : prefix + ".";
            DataSourcePoolMetadata metadata = entry.getValue();
            this.addMetric(metrics, prefix + "active", metadata.getActive());
            this.addMetric(metrics, prefix + "usage", metadata.getUsage());
        }
        return metrics;
    }

    private <T extends Number> void addMetric(Set<Metric<?>> metrics, String name, T value) {
        if (value != null) {
            metrics.add(new Metric<T>(name, value));
        }
    }

    protected String createPrefix(String name, DataSource dataSource, boolean primary) {
        if (primary) {
            return "datasource.primary";
        }
        if (name.length() > DATASOURCE_SUFFIX.length() && name.toLowerCase().endsWith(DATASOURCE_SUFFIX.toLowerCase())) {
            name = name.substring(0, name.length() - DATASOURCE_SUFFIX.length());
        }
        return "datasource." + name;
    }

    private DataSource getPrimaryDataSource() {
        try {
            return (DataSource)this.applicationContext.getBean(DataSource.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }
}

