/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.DataEndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.LoggersEndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.ShutdownEndpointMBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EndpointMBeanExporter
extends MBeanExporter
implements SmartLifecycle,
ApplicationContextAware {
    public static final String DEFAULT_DOMAIN = "org.springframework.boot";
    private static final Log logger = LogFactory.getLog(EndpointMBeanExporter.class);
    private final AnnotationJmxAttributeSource attributeSource = new EndpointJmxAttributeSource();
    private final MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource);
    private final MetadataNamingStrategy defaultNamingStrategy = new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource);
    private final Set<Class<?>> registeredEndpoints = new HashSet();
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running = false;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private ApplicationContext applicationContext;
    private ListableBeanFactory beanFactory;
    private String domain = "org.springframework.boot";
    private boolean ensureUniqueRuntimeObjectNames = false;
    private Properties objectNameStaticProperties = new Properties();
    private final ObjectMapper objectMapper;

    public EndpointMBeanExporter() {
        this(null);
    }

    public EndpointMBeanExporter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper;
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)this.defaultNamingStrategy);
        this.setAssembler((MBeanInfoAssembler)this.assembler);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            logger.warn((Object)"EndpointMBeanExporter not running in a ListableBeanFactory: autodetection of Endpoints not available.");
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        super.setEnsureUniqueRuntimeObjectNames(ensureUniqueRuntimeObjectNames);
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    public void setObjectNameStaticProperties(Properties objectNameStaticProperties) {
        this.objectNameStaticProperties = objectNameStaticProperties;
    }

    protected void doStart() {
        this.locateAndRegisterEndpoints();
    }

    protected void locateAndRegisterEndpoints() {
        this.registerJmxEndpoints(this.beanFactory.getBeansOfType(JmxEndpoint.class));
        this.registerEndpoints(this.beanFactory.getBeansOfType(Endpoint.class));
    }

    private void registerJmxEndpoints(Map<String, JmxEndpoint> endpoints) {
        for (Map.Entry<String, JmxEndpoint> entry : endpoints.entrySet()) {
            String name = entry.getKey();
            JmxEndpoint endpoint = entry.getValue();
            Class<Endpoint<Object>> type = endpoint.getEndpointType() != null ? endpoint.getEndpointType() : endpoint.getClass();
            if (this.registeredEndpoints.contains(type) || !endpoint.isEnabled()) continue;
            try {
                this.registerBeanNameOrInstance(endpoint, name);
            }
            catch (MBeanExportException ex) {
                logger.error((Object)("Could not register JmxEndpoint [" + name + "]"), (Throwable)ex);
            }
            this.registeredEndpoints.add(type);
        }
    }

    private void registerEndpoints(Map<String, Endpoint> endpoints) {
        for (Map.Entry<String, Endpoint> entry : endpoints.entrySet()) {
            String name = entry.getKey();
            Endpoint endpoint = entry.getValue();
            Class<?> type = endpoint.getClass();
            if (this.registeredEndpoints.contains(type) || !endpoint.isEnabled()) continue;
            this.registerEndpoint(name, endpoint);
            this.registeredEndpoints.add(type);
        }
    }

    @Deprecated
    protected void registerEndpoint(String beanName, Endpoint<?> endpoint) {
        Class<?> type = endpoint.getClass();
        if (this.isAnnotatedWithManagedResource(type) || type.isMemberClass() && this.isAnnotatedWithManagedResource(type.getEnclosingClass())) {
            return;
        }
        JmxEndpoint jmxEndpoint = this.adaptEndpoint(beanName, endpoint);
        try {
            this.registerBeanNameOrInstance(jmxEndpoint, beanName);
        }
        catch (MBeanExportException ex) {
            logger.error((Object)("Could not register MBean for endpoint [" + beanName + "]"), (Throwable)ex);
        }
    }

    private boolean isAnnotatedWithManagedResource(Class<?> type) {
        return AnnotationUtils.findAnnotation(type, ManagedResource.class) != null;
    }

    protected JmxEndpoint adaptEndpoint(String beanName, Endpoint<?> endpoint) {
        return this.getEndpointMBean(beanName, endpoint);
    }

    @Deprecated
    protected EndpointMBean getEndpointMBean(String beanName, Endpoint<?> endpoint) {
        if (endpoint instanceof ShutdownEndpoint) {
            return new ShutdownEndpointMBean(beanName, endpoint, this.objectMapper);
        }
        if (endpoint instanceof LoggersEndpoint) {
            return new LoggersEndpointMBean(beanName, endpoint, this.objectMapper);
        }
        return new DataEndpointMBean(beanName, endpoint, this.objectMapper);
    }

    protected ObjectName getObjectName(Object bean, String beanKey) throws MalformedObjectNameException {
        if (bean instanceof SelfNaming) {
            return ((SelfNaming)bean).getObjectName();
        }
        if (bean instanceof JmxEndpoint) {
            return this.getObjectName((JmxEndpoint)bean, beanKey);
        }
        return this.defaultNamingStrategy.getObjectName(bean, beanKey);
    }

    private ObjectName getObjectName(JmxEndpoint jmxEndpoint, String beanKey) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.domain);
        builder.append(":type=Endpoint");
        builder.append(",name=" + beanKey);
        if (this.parentContextContainsSameBean(this.applicationContext, beanKey)) {
            builder.append(",context=" + ObjectUtils.getIdentityHexString((Object)this.applicationContext));
        }
        if (this.ensureUniqueRuntimeObjectNames) {
            builder.append(",identity=" + jmxEndpoint.getIdentity());
        }
        builder.append(this.getStaticNames());
        return ObjectNameManager.getInstance((String)builder.toString());
    }

    private boolean parentContextContainsSameBean(ApplicationContext applicationContext, String beanKey) {
        if (applicationContext.getParent() != null) {
            try {
                this.applicationContext.getParent().getBean(beanKey, Endpoint.class);
                return true;
            }
            catch (BeansException ex) {
                return this.parentContextContainsSameBean(applicationContext.getParent(), beanKey);
            }
        }
        return false;
    }

    private String getStaticNames() {
        if (this.objectNameStaticProperties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> name : this.objectNameStaticProperties.entrySet()) {
            builder.append("," + name.getKey() + "=" + name.getValue());
        }
        return builder.toString();
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.running = false;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private static class EndpointJmxAttributeSource
    extends AnnotationJmxAttributeSource {
        private EndpointJmxAttributeSource() {
        }

        public org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
            Assert.state((super.getManagedResource(beanClass) == null ? 1 : 0) != 0, (String)("@ManagedResource annotation found on JmxEndpoint " + beanClass));
            return new org.springframework.jmx.export.metadata.ManagedResource();
        }
    }
}

