/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.endpoint.MetricReaderPublicMetrics;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.dropwizard.DropwizardMetricServices;
import org.springframework.boot.actuate.metrics.dropwizard.ReservoirFactory;
import org.springframework.boot.actuate.metrics.reader.MetricRegistryMetricReader;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
public class MetricsDropwizardAutoConfiguration {
    private final ReservoirFactory reservoirFactory;

    public MetricsDropwizardAutoConfiguration(ObjectProvider<ReservoirFactory> reservoirFactory) {
        this.reservoirFactory = (ReservoirFactory)reservoirFactory.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={DropwizardMetricServices.class, CounterService.class, GaugeService.class})
    public DropwizardMetricServices dropwizardMetricServices(MetricRegistry metricRegistry) {
        if (this.reservoirFactory == null) {
            return new DropwizardMetricServices(metricRegistry);
        }
        return new DropwizardMetricServices(metricRegistry, this.reservoirFactory);
    }

    @Bean
    public MetricReaderPublicMetrics dropwizardPublicMetrics(MetricRegistry metricRegistry) {
        MetricRegistryMetricReader reader = new MetricRegistryMetricReader(metricRegistry);
        return new MetricReaderPublicMetrics(reader);
    }
}

