/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.security.SecurityPrerequisite;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management", ignoreUnknownFields=true)
public class ManagementServerProperties
implements SecurityPrerequisite {
    public static final int BASIC_AUTH_ORDER = 0x7FFFFFF5;
    public static final int ACCESS_OVERRIDE_ORDER = 0x7FFFFFF4;
    private Integer port;
    @NestedConfigurationProperty
    private Ssl ssl;
    private InetAddress address;
    private String contextPath = "";
    private boolean addApplicationContextHeader = true;
    private final Security security = new Security();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"ContextPath must not be null");
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public Security getSecurity() {
        return this.security;
    }

    public boolean getAddApplicationContextHeader() {
        return this.addApplicationContextHeader;
    }

    public void setAddApplicationContextHeader(boolean addApplicationContextHeader) {
        this.addApplicationContextHeader = addApplicationContextHeader;
    }

    public static enum SessionCreationPolicy {
        ALWAYS,
        NEVER,
        IF_REQUIRED,
        STATELESS;

    }

    public static class Security {
        private boolean enabled = true;
        private List<String> roles = Arrays.asList("ACTUATOR");
        private SessionCreationPolicy sessions = SessionCreationPolicy.STATELESS;

        public SessionCreationPolicy getSessions() {
            return this.sessions;
        }

        public void setSessions(SessionCreationPolicy sessions) {
            this.sessions = sessions;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

