/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cloudfoundry;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.boot.actuate.autoconfigure.EndpointWebMvcAutoConfiguration;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundryEndpointHandlerMapping;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundrySecurityService;
import org.springframework.boot.actuate.cloudfoundry.TokenValidator;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.actuate.endpoint.mvc.NamedMvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.IgnoredRequestCustomizer;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration
@ConditionalOnProperty(prefix="management.cloudfoundry", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={MvcEndpoints.class})
@AutoConfigureAfter(value={EndpointWebMvcAutoConfiguration.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class CloudFoundryActuatorAutoConfiguration {
    @Bean
    public CloudFoundryEndpointHandlerMapping cloudFoundryEndpointHandlerMapping(MvcEndpoints mvcEndpoints, RestTemplateBuilder restTemplateBuilder, Environment environment) {
        LinkedHashSet<NamedMvcEndpoint> endpoints = new LinkedHashSet<NamedMvcEndpoint>(mvcEndpoints.getEndpoints(NamedMvcEndpoint.class));
        HandlerInterceptor securityInterceptor = this.getSecurityInterceptor(restTemplateBuilder, environment);
        CorsConfiguration corsConfiguration = this.getCorsConfiguration();
        CloudFoundryEndpointHandlerMapping mapping = new CloudFoundryEndpointHandlerMapping(endpoints, corsConfiguration, securityInterceptor);
        mapping.setPrefix("/cloudfoundryapplication");
        return mapping;
    }

    private HandlerInterceptor getSecurityInterceptor(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        CloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(restTemplateBuilder, environment);
        TokenValidator tokenValidator = new TokenValidator(cloudfoundrySecurityService);
        CloudFoundrySecurityInterceptor securityInterceptor = new CloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment.getProperty("vcap.application.application_id"));
        return securityInterceptor;
    }

    private CloudFoundrySecurityService getCloudFoundrySecurityService(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        RelaxedPropertyResolver cloudFoundryProperties = new RelaxedPropertyResolver((PropertyResolver)environment, "management.cloudfoundry.");
        String cloudControllerUrl = environment.getProperty("vcap.application.cf_api");
        boolean skipSslValidation = (Boolean)cloudFoundryProperties.getProperty("skip-ssl-validation", Boolean.class, (Object)false);
        return cloudControllerUrl == null ? null : new CloudFoundrySecurityService(restTemplateBuilder, cloudControllerUrl, skipSslValidation);
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    @ConditionalOnClass(value={WebSecurity.class})
    static class CloudFoundryIgnoredRequestConfiguration {
        CloudFoundryIgnoredRequestConfiguration() {
        }

        @Bean
        public IgnoredRequestCustomizer cloudFoundryIgnoredRequestCustomizer() {
            return new CloudFoundryIgnoredRequestCustomizer();
        }

        private static class CloudFoundryIgnoredRequestCustomizer
        implements IgnoredRequestCustomizer {
            private CloudFoundryIgnoredRequestCustomizer() {
            }

            public void customize(WebSecurity.IgnoredRequestConfigurer configurer) {
                configurer.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/cloudfoundryapplication/**")});
            }
        }
    }
}

