/*
 * Copyright 2012-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.http.MediaType;

/**
 * {@link MediaType MediaTypes} that can be consumed and produced by Actuator endpoints.
 *
 * @author Andy Wilkinson
 * @since 1.5.0
 */
public final class ActuatorMediaTypes {

	/**
	 * {@link String} equivalent of {@link #APPLICATION_ACTUATOR_V1_JSON}.
	 */
	public static final String APPLICATION_ACTUATOR_V1_JSON_VALUE = "application/vnd.spring-boot.actuator.v1+json";

	/**
	 * The {@code application/vnd.spring-boot.actuator.v1+json} media type.
	 */
	public static final MediaType APPLICATION_ACTUATOR_V1_JSON = MediaType
			.valueOf(APPLICATION_ACTUATOR_V1_JSON_VALUE);

	private ActuatorMediaTypes() {

	}

}
