/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cloudfoundry;

import org.springframework.http.HttpStatus;

class CloudFoundryAuthorizationException
extends RuntimeException {
    private final Reason reason;

    CloudFoundryAuthorizationException(Reason reason, String message) {
        this(reason, message, null);
    }

    CloudFoundryAuthorizationException(Reason reason, String message, Throwable cause) {
        super(message);
        this.reason = reason;
    }

    public HttpStatus getStatusCode() {
        return this.getReason().getStatus();
    }

    public Reason getReason() {
        return this.reason;
    }

    static enum Reason {
        ACCESS_DENIED(HttpStatus.FORBIDDEN),
        INVALID_AUDIENCE(HttpStatus.UNAUTHORIZED),
        INVALID_ISSUER(HttpStatus.UNAUTHORIZED),
        INVALID_KEY_ID(HttpStatus.UNAUTHORIZED),
        INVALID_SIGNATURE(HttpStatus.UNAUTHORIZED),
        INVALID_TOKEN(HttpStatus.UNAUTHORIZED),
        MISSING_AUTHORIZATION(HttpStatus.UNAUTHORIZED),
        TOKEN_EXPIRED(HttpStatus.UNAUTHORIZED),
        UNSUPPORTED_TOKEN_SIGNING_ALGORITHM(HttpStatus.UNAUTHORIZED),
        SERVICE_UNAVAILABLE(HttpStatus.SERVICE_UNAVAILABLE);

        private final HttpStatus status;

        private Reason(HttpStatus status) {
            this.status = status;
        }

        public HttpStatus getStatus() {
            return this.status;
        }
    }
}

