/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.cluster.ClusterInfo;
import java.util.Collection;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CouchbaseHealthIndicator
extends AbstractHealthIndicator {
    private CouchbaseOperations operations;

    public CouchbaseHealthIndicator() {
        super("Couchbase health check failed");
    }

    public CouchbaseHealthIndicator(CouchbaseOperations couchbaseOperations) {
        super("Couchbase health check failed");
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null");
        this.operations = couchbaseOperations;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ClusterInfo cluster = this.operations.getCouchbaseClusterInfo();
        BucketInfo bucket = this.operations.getCouchbaseBucket().bucketManager().info();
        String versions = StringUtils.collectionToCommaDelimitedString((Collection)cluster.getAllVersions());
        String nodes = StringUtils.collectionToCommaDelimitedString((Collection)bucket.nodeList());
        builder.up().withDetail("versions", versions).withDetail("nodes", nodes);
    }
}

