/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.CompositeReactiveHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorNameFactory;
import org.springframework.boot.actuate.health.HealthIndicatorReactiveAdapter;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CompositeReactiveHealthIndicatorFactory {
    private final Function<String, String> healthIndicatorNameFactory;

    public CompositeReactiveHealthIndicatorFactory(Function<String, String> healthIndicatorNameFactory) {
        this.healthIndicatorNameFactory = healthIndicatorNameFactory;
    }

    public CompositeReactiveHealthIndicatorFactory() {
        this(new HealthIndicatorNameFactory());
    }

    public CompositeReactiveHealthIndicator createReactiveHealthIndicator(HealthAggregator healthAggregator, Map<String, ReactiveHealthIndicator> reactiveHealthIndicators, Map<String, HealthIndicator> healthIndicators) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        Assert.notNull(reactiveHealthIndicators, (String)"ReactiveHealthIndicators must not be null");
        CompositeReactiveHealthIndicator healthIndicator = new CompositeReactiveHealthIndicator(healthAggregator);
        this.merge(reactiveHealthIndicators, healthIndicators).forEach((beanName, indicator) -> {
            String name = this.healthIndicatorNameFactory.apply((String)beanName);
            healthIndicator.addHealthIndicator(name, (ReactiveHealthIndicator)indicator);
        });
        return healthIndicator;
    }

    private Map<String, ReactiveHealthIndicator> merge(Map<String, ReactiveHealthIndicator> reactiveHealthIndicators, Map<String, HealthIndicator> healthIndicators) {
        if (ObjectUtils.isEmpty(healthIndicators)) {
            return reactiveHealthIndicators;
        }
        LinkedHashMap<String, ReactiveHealthIndicator> allIndicators = new LinkedHashMap<String, ReactiveHealthIndicator>(reactiveHealthIndicators);
        healthIndicators.forEach((beanName, indicator) -> {
            String name = this.healthIndicatorNameFactory.apply((String)beanName);
            allIndicators.computeIfAbsent(name, n -> new HealthIndicatorReactiveAdapter((HealthIndicator)indicator));
        });
        return allIndicators;
    }
}

