/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.logging;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Endpoint(id="loggers")
public class LoggersEndpoint {
    private final LoggingSystem loggingSystem;

    public LoggersEndpoint(LoggingSystem loggingSystem) {
        Assert.notNull((Object)loggingSystem, (String)"LoggingSystem must not be null");
        this.loggingSystem = loggingSystem;
    }

    @ReadOperation
    public Map<String, Object> loggers() {
        List configurations = this.loggingSystem.getLoggerConfigurations();
        if (configurations == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("levels", this.getLevels());
        result.put("loggers", this.getLoggers(configurations));
        return result;
    }

    @ReadOperation
    public LoggerLevels loggerLevels(@Selector String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        LoggerConfiguration configuration = this.loggingSystem.getLoggerConfiguration(name);
        return configuration != null ? new LoggerLevels(configuration) : null;
    }

    @WriteOperation
    public void configureLogLevel(@Selector String name, @Nullable LogLevel configuredLevel) {
        Assert.notNull((Object)name, (String)"Name must not be empty");
        this.loggingSystem.setLogLevel(name, configuredLevel);
    }

    private NavigableSet<LogLevel> getLevels() {
        Set levels = this.loggingSystem.getSupportedLogLevels();
        return new TreeSet(levels).descendingSet();
    }

    private Map<String, LoggerLevels> getLoggers(Collection<LoggerConfiguration> configurations) {
        LinkedHashMap<String, LoggerLevels> loggers = new LinkedHashMap<String, LoggerLevels>(configurations.size());
        for (LoggerConfiguration configuration : configurations) {
            loggers.put(configuration.getName(), new LoggerLevels(configuration));
        }
        return loggers;
    }

    public static class LoggerLevels {
        private String configuredLevel;
        private String effectiveLevel;

        public LoggerLevels(LoggerConfiguration configuration) {
            this.configuredLevel = this.getName(configuration.getConfiguredLevel());
            this.effectiveLevel = this.getName(configuration.getEffectiveLevel());
        }

        private String getName(LogLevel level) {
            return level != null ? level.name() : null;
        }

        public String getConfiguredLevel() {
            return this.configuredLevel;
        }

        public String getEffectiveLevel() {
            return this.effectiveLevel;
        }
    }
}

