/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsProvider;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class MetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebFluxTagsProvider tagsProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    public MetricsWebFilter(MeterRegistry registry, WebFluxTagsProvider tagsProvider, String metricName, AutoTimer autoTimer) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimer = autoTimer != null ? autoTimer : AutoTimer.DISABLED;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!this.autoTimer.isEnabled()) {
            return chain.filter(exchange);
        }
        return chain.filter(exchange).transformDeferred(call -> this.filter(exchange, (Mono<Void>)call));
    }

    private Publisher<Void> filter(ServerWebExchange exchange, Mono<Void> call) {
        long start = System.nanoTime();
        return call.doOnSuccess(done -> this.onSuccess(exchange, start)).doOnError(cause -> this.onError(exchange, start, (Throwable)cause));
    }

    private void onSuccess(ServerWebExchange exchange, long start) {
        this.record(exchange, start, null);
    }

    private void onError(ServerWebExchange exchange, long start, Throwable cause) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            this.record(exchange, start, cause);
        } else {
            response.beforeCommit(() -> {
                this.record(exchange, start, cause);
                return Mono.empty();
            });
        }
    }

    private void record(ServerWebExchange exchange, long start, Throwable cause) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange, cause);
        this.autoTimer.builder(this.metricName).tags(tags).register(this.registry).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }
}

