/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.NamedContributors;
import org.springframework.util.Assert;

abstract class NamedContributorsMapAdapter<V, C>
implements NamedContributors<C> {
    private final Map<String, V> map;
    private final Function<V, ? extends C> valueAdapter;

    NamedContributorsMapAdapter(Map<String, V> map, Function<V, ? extends C> valueAdapter) {
        Assert.notNull(map, (String)"Map must not be null");
        Assert.notNull(valueAdapter, (String)"ValueAdapter must not be null");
        map.keySet().forEach(key -> Assert.notNull((Object)key, (String)"Map must not contain null keys"));
        map.values().stream().map(valueAdapter).forEach(value -> Assert.notNull((Object)value, (String)"Map must not contain null values"));
        this.map = Collections.unmodifiableMap(new LinkedHashMap<String, V>(map));
        this.valueAdapter = valueAdapter;
    }

    @Override
    public Iterator<NamedContributor<C>> iterator() {
        final Iterator<Map.Entry<String, V>> iterator = this.map.entrySet().iterator();
        return new Iterator<NamedContributor<C>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public NamedContributor<C> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return NamedContributor.of((String)entry.getKey(), NamedContributorsMapAdapter.this.adapt(entry.getValue()));
            }
        };
    }

    @Override
    public C getContributor(String name) {
        return this.adapt(this.map.get(name));
    }

    private C adapt(V value) {
        return value != null ? (C)this.valueAdapter.apply(value) : null;
    }
}

