/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigureprocessor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"org.springframework.context.annotation.Configuration", "org.springframework.boot.autoconfigure.condition.ConditionalOnClass", "org.springframework.boot.autoconfigure.AutoConfigureBefore", "org.springframework.boot.autoconfigure.AutoConfigureAfter", "org.springframework.boot.autoconfigure.AutoConfigureOrder"})
public class AutoConfigureAnnotationProcessor
extends AbstractProcessor {
    protected static final String PROPERTIES_PATH = "META-INF/spring-autoconfigure-metadata.properties";
    private Map<String, String> annotations;
    private final Properties properties = new Properties();

    public AutoConfigureAnnotationProcessor() {
        LinkedHashMap<String, String> annotations = new LinkedHashMap<String, String>();
        this.addAnnotations(annotations);
        this.annotations = Collections.unmodifiableMap(annotations);
    }

    protected void addAnnotations(Map<String, String> annotations) {
        annotations.put("Configuration", "org.springframework.context.annotation.Configuration");
        annotations.put("ConditionalOnClass", "org.springframework.boot.autoconfigure.condition.ConditionalOnClass");
        annotations.put("AutoConfigureBefore", "org.springframework.boot.autoconfigure.AutoConfigureBefore");
        annotations.put("AutoConfigureAfter", "org.springframework.boot.autoconfigure.AutoConfigureAfter");
        annotations.put("AutoConfigureOrder", "org.springframework.boot.autoconfigure.AutoConfigureOrder");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Map.Entry<String, String> entry : this.annotations.entrySet()) {
            this.process(roundEnv, entry.getKey(), entry.getValue());
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeProperties();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
        }
        return false;
    }

    private void process(RoundEnvironment roundEnv, String propertyKey, String annotationName) {
        TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(annotationName);
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                Element enclosingElement = element.getEnclosingElement();
                if (enclosingElement == null || enclosingElement.getKind() != ElementKind.PACKAGE) continue;
                this.processElement(element, propertyKey, annotationName);
            }
        }
    }

    private void processElement(Element element, String propertyKey, String annotationName) {
        try {
            String qualifiedName = this.getQualifiedName(element);
            AnnotationMirror annotation = this.getAnnotation(element, annotationName);
            if (qualifiedName != null && annotation != null) {
                List<Object> values = this.getValues(annotation);
                this.properties.put(qualifiedName + "." + propertyKey, this.toCommaDelimitedString(values));
                this.properties.put(qualifiedName, "");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private String toCommaDelimitedString(List<Object> list) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(result.length() != 0 ? "," : "");
            result.append(item);
        }
        return result.toString();
    }

    private List<Object> getValues(AnnotationMirror annotation) {
        return annotation.getElementValues().entrySet().stream().filter(this::isNameOrValueAttribute).flatMap(this::getValues).collect(Collectors.toList());
    }

    private boolean isNameOrValueAttribute(Map.Entry<? extends ExecutableElement, ?> entry) {
        String attributeName = entry.getKey().getSimpleName().toString();
        return "name".equals(attributeName) || "value".equals(attributeName);
    }

    private Stream<Object> getValues(Map.Entry<?, ? extends AnnotationValue> entry) {
        Object value = entry.getValue().getValue();
        if (value instanceof List) {
            return ((List)value).stream().map(annotation -> this.processValue(annotation.getValue()));
        }
        return Stream.of(this.processValue(value));
    }

    private Object processValue(Object value) {
        if (value instanceof DeclaredType) {
            return this.getQualifiedName(((DeclaredType)value).asElement());
        }
        return value;
    }

    private String getQualifiedName(Element element) {
        if (element != null) {
            TypeElement enclosingElement = this.getEnclosingTypeElement(element.asType());
            if (enclosingElement != null) {
                return this.getQualifiedName(enclosingElement) + "$" + ((DeclaredType)element.asType()).asElement().getSimpleName().toString();
            }
            if (element instanceof TypeElement) {
                return ((TypeElement)element).getQualifiedName().toString();
            }
        }
        return null;
    }

    private TypeElement getEnclosingTypeElement(TypeMirror type) {
        DeclaredType declaredType;
        Element enclosingElement;
        if (type instanceof DeclaredType && (enclosingElement = (declaredType = (DeclaredType)type).asElement().getEnclosingElement()) != null && enclosingElement instanceof TypeElement) {
            return (TypeElement)enclosingElement;
        }
        return null;
    }

    private void writeProperties() throws IOException {
        if (!this.properties.isEmpty()) {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PROPERTIES_PATH, new Element[0]);
            try (OutputStream outputStream = file.openOutputStream();){
                this.properties.store(outputStream, null);
            }
        }
    }
}

