/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class})
@AutoConfigureOrder(value=-2147483648)
@Conditional(value={ResourceBundleCondition.class})
@EnableConfigurationProperties
@ConfigurationProperties(prefix="spring.messages")
public class MessageSourceAutoConfiguration {
    private static final Resource[] NO_RESOURCES = new Resource[0];
    private String basename = "messages";
    private String encoding = "utf-8";
    private int cacheSeconds = -1;

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        if (StringUtils.hasText((String)this.basename)) {
            messageSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.basename)));
        }
        messageSource.setDefaultEncoding(this.encoding);
        messageSource.setCacheSeconds(this.cacheSeconds);
        return messageSource;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    private static class SkipPatternPathMatchingResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        private static final ClassLoader ROOT_CLASSLOADER;
        private static final String[] SKIPPED;

        public SkipPatternPathMatchingResourcePatternResolver(ClassLoader classLoader) {
            super(classLoader);
        }

        protected void addAllClassLoaderJarRoots(ClassLoader classLoader, Set<Resource> result) {
            if (classLoader != ROOT_CLASSLOADER) {
                super.addAllClassLoaderJarRoots(classLoader, result);
            }
        }

        protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
            Set resources = super.doFindAllClassPathResources(path);
            Iterator iterator = resources.iterator();
            block0: while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                for (String skipped : SKIPPED) {
                    if (!resource.getFilename().startsWith(skipped)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            return resources;
        }

        static {
            ClassLoader classLoader = null;
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                while (classLoader.getParent() != null) {
                    classLoader = classLoader.getParent();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ROOT_CLASSLOADER = classLoader;
            SKIPPED = new String[]{"aspectjweaver-", "hibernate-core-", "hsqldb-", "jackson-annotations-", "jackson-core-", "jackson-databind-", "javassist-", "snakeyaml-", "spring-aop-", "spring-beans-", "spring-boot-", "spring-boot-actuator-", "spring-boot-autoconfigure-", "spring-core-", "spring-context-", "spring-data-commons-", "spring-expression-", "spring-jdbc-", "spring-orm-", "spring-tx-", "spring-web-", "spring-webmvc-", "tomcat-embed-", "joda-time-", "hibernate-entitymanager-", "hibernate-validator-", "logback-classic-", "logback-core-", "thymeleaf-"};
        }
    }

    protected static class ResourceBundleCondition
    extends SpringBootCondition {
        private static ConcurrentReferenceHashMap<String, ConditionOutcome> cache = new ConcurrentReferenceHashMap();

        protected ResourceBundleCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String basename = context.getEnvironment().getProperty("spring.messages.basename", "messages");
            ConditionOutcome outcome = (ConditionOutcome)cache.get((Object)basename);
            if (outcome == null) {
                outcome = this.getMatchOutcomeForBasename(context, basename);
                cache.put((Object)basename, (Object)outcome);
            }
            return outcome;
        }

        private ConditionOutcome getMatchOutcomeForBasename(ConditionContext context, String basename) {
            for (String name : StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)basename))) {
                for (Resource resource : this.getResources(context.getClassLoader(), name)) {
                    if (!resource.exists()) continue;
                    return ConditionOutcome.match("Bundle found for spring.messages.basename: " + name);
                }
            }
            return ConditionOutcome.noMatch("No bundle found for spring.messages.basename: " + basename);
        }

        private Resource[] getResources(ClassLoader classLoader, String name) {
            try {
                return new SkipPatternPathMatchingResourcePatternResolver(classLoader).getResources("classpath*:" + name + "*.properties");
            }
            catch (Exception ex) {
                return NO_RESOURCES;
            }
        }
    }
}

