/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheConfigFileCondition;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnClass(value={HazelcastInstance.class, HazelcastCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@Conditional(value={CacheCondition.class, ConfigAvailableCondition.class})
class HazelcastCacheConfiguration {
    static final String CONFIG_SYSTEM_PROPERTY = "hazelcast.config";
    @Autowired
    private CacheProperties cacheProperties;

    HazelcastCacheConfiguration() {
    }

    @Bean
    public HazelcastCacheManager cacheManager(HazelcastInstance hazelcastInstance) {
        return new HazelcastCacheManager(hazelcastInstance);
    }

    @Bean
    @ConditionalOnMissingBean
    public HazelcastInstance hazelcastInstance() throws IOException {
        Resource location = this.cacheProperties.resolveConfigLocation(this.cacheProperties.getHazelcast().getConfig());
        if (location != null) {
            Config cfg = new XmlConfigBuilder(location.getURL()).build();
            return Hazelcast.newHazelcastInstance((Config)cfg);
        }
        return Hazelcast.newHazelcastInstance();
    }

    static class ConfigAvailableCondition
    extends CacheConfigFileCondition {
        public ConfigAvailableCondition() {
            super("Hazelcast", "spring.config.hazelcast", "file:./hazelcast.xml", "classpath:/hazelcast.xml");
        }

        @Override
        protected ConditionOutcome getResourceOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (System.getProperty(HazelcastCacheConfiguration.CONFIG_SYSTEM_PROPERTY) != null) {
                return ConditionOutcome.match("System property 'hazelcast.config' is set.");
            }
            return super.getResourceOutcome(context, metadata);
        }
    }
}

