/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mustache.MustacheEnvironmentCollector;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.autoconfigure.mustache.MustacheResourceTemplateLoader;
import org.springframework.boot.autoconfigure.mustache.web.MustacheViewResolver;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={Mustache.class})
@EnableConfigurationProperties(value={MustacheProperties.class})
public class MustacheAutoConfiguration {
    @Autowired
    private MustacheProperties mustache;
    @Autowired
    private Environment environment;
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void checkTemplateLocationExists() {
        if (this.mustache.isCheckTemplateLocation()) {
            TemplateLocation location = new TemplateLocation(this.mustache.getPrefix());
            Assert.state((boolean)location.exists((ResourcePatternResolver)this.applicationContext), (String)("Cannot find template location: " + location + " (please add some templates, check your Mustache " + "configuration, or set spring.mustache." + "check-template-location=false)"));
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={Mustache.Compiler.class})
    public Mustache.Compiler mustacheCompiler(Mustache.TemplateLoader mustacheTemplateLoader) {
        return Mustache.compiler().withLoader(mustacheTemplateLoader).withCollector(this.collector());
    }

    private Mustache.Collector collector() {
        MustacheEnvironmentCollector collector = new MustacheEnvironmentCollector();
        collector.setEnvironment(this.environment);
        return collector;
    }

    @Bean
    @ConditionalOnMissingBean(value={Mustache.TemplateLoader.class})
    public MustacheResourceTemplateLoader mustacheTemplateLoader() {
        MustacheResourceTemplateLoader loader = new MustacheResourceTemplateLoader(this.mustache.getPrefix(), this.mustache.getSuffix());
        loader.setCharset(this.mustache.getCharset());
        return loader;
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class MustacheWebConfiguration {
        @Autowired
        private MustacheProperties mustache;

        protected MustacheWebConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MustacheViewResolver.class})
        public MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler) {
            MustacheViewResolver resolver = new MustacheViewResolver();
            resolver.setPrefix(this.mustache.getPrefix());
            resolver.setSuffix(this.mustache.getSuffix());
            resolver.setCache(this.mustache.isCache());
            resolver.setViewNames(this.mustache.getViewNames());
            resolver.setContentType(this.mustache.getContentType());
            resolver.setCharset(this.mustache.getCharset());
            resolver.setCompiler(mustacheCompiler);
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }
    }
}

