/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.authserver;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.config.annotation.builders.ClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
@ConditionalOnClass(value={EnableAuthorizationServer.class})
@ConditionalOnMissingBean(value={AuthorizationServerConfigurer.class})
@ConditionalOnBean(value={AuthorizationServerEndpointsConfiguration.class})
@EnableConfigurationProperties
public class SpringSecurityOAuth2AuthorizationServerConfiguration
extends AuthorizationServerConfigurerAdapter {
    private static final Log logger = LogFactory.getLog(SpringSecurityOAuth2AuthorizationServerConfiguration.class);
    @Autowired
    private BaseClientDetails details;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired(required=false)
    private TokenStore tokenStore;

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        ClientDetailsServiceBuilder.ClientBuilder builder = clients.inMemory().withClient(this.details.getClientId());
        builder.secret(this.details.getClientSecret()).resourceIds(this.details.getResourceIds().toArray(new String[0])).authorizedGrantTypes(this.details.getAuthorizedGrantTypes().toArray(new String[0])).authorities(AuthorityUtils.authorityListToSet((Collection)this.details.getAuthorities()).toArray(new String[0])).scopes(this.details.getScope().toArray(new String[0]));
        if (this.details.getRegisteredRedirectUri() != null) {
            builder.redirectUris(this.details.getRegisteredRedirectUri().toArray(new String[0]));
        }
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        if (this.tokenStore != null) {
            endpoints.tokenStore(this.tokenStore);
        }
        if (this.details.getAuthorizedGrantTypes().contains("password")) {
            endpoints.authenticationManager(this.authenticationManager);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={BaseClientDetails.class})
    protected static class BaseClientDetailsConfiguration {
        @Autowired
        private OAuth2ClientProperties client;

        protected BaseClientDetailsConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="spring.oauth2.client")
        public BaseClientDetails oauth2ClientDetails() {
            BaseClientDetails details = new BaseClientDetails();
            if (this.client.getClientId() == null) {
                this.client.setClientId(UUID.randomUUID().toString());
            }
            details.setClientId(this.client.getClientId());
            details.setClientSecret(this.client.getClientSecret());
            details.setAuthorizedGrantTypes(Arrays.asList("authorization_code", "password", "client_credentials", "implicit", "refresh_token"));
            details.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
            details.setRegisteredRedirectUri(Collections.emptySet());
            return details;
        }
    }

    @Configuration
    protected static class ClientDetailsLogger {
        @Autowired
        private OAuth2ClientProperties credentials;

        protected ClientDetailsLogger() {
        }

        @PostConstruct
        public void init() {
            String prefix = "spring.oauth2.client";
            boolean defaultSecret = this.credentials.isDefaultSecret();
            logger.info((Object)String.format("Initialized OAuth2 Client\n\n%s.clientId = %s\n%s.secret = %s\n\n", prefix, this.credentials.getClientId(), prefix, defaultSecret ? this.credentials.getClientSecret() : "****"));
        }
    }
}

