/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationSorter;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Order(value=0x7FFFFFFE)
public class EnableAutoConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware,
ResourceLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader beanClassLoader;
    private ResourceLoader resourceLoader;

    public String[] selectImports(AnnotationMetadata metadata) {
        try {
            AnnotationAttributes attributes = this.getAttributes(metadata);
            List<String> configurations = this.getCandidateConfigurations(metadata, attributes);
            configurations = this.removeDuplicates(configurations);
            Set<String> exclusions = this.getExclusions(metadata, attributes);
            configurations.removeAll(exclusions);
            configurations = this.sort(configurations);
            this.recordWithConditionEvaluationReport(configurations, exclusions);
            return configurations.toArray(new String[configurations.size()]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        String name = this.getAnnotationClass().getName();
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(name, true));
        Assert.notNull((Object)attributes, (String)("No auto-configuration attributes found. Is " + metadata.getClassName() + " annotated with " + ClassUtils.getShortName((String)name) + "?"));
        return attributes;
    }

    protected Class<?> getAnnotationClass() {
        return EnableAutoConfiguration.class;
    }

    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        return SpringFactoriesLoader.loadFactoryNames(this.getSpringFactoriesLoaderFactoryClass(), (ClassLoader)this.getBeanClassLoader());
    }

    protected Class<?> getSpringFactoriesLoaderFactoryClass() {
        return EnableAutoConfiguration.class;
    }

    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        LinkedHashSet<String> excluded = new LinkedHashSet<String>();
        excluded.addAll(this.asList(attributes, "exclude"));
        excluded.addAll(Arrays.asList(attributes.getStringArray("excludeName")));
        excluded.addAll(this.getExcludeAutoConfigurationsProperty());
        return excluded;
    }

    private List<String> getExcludeAutoConfigurationsProperty() {
        if (this.getEnvironment() instanceof ConfigurableEnvironment) {
            Excludes excludes = new Excludes();
            RelaxedDataBinder binder = new RelaxedDataBinder((Object)excludes, "spring.autoconfigure.");
            binder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)((ConfigurableEnvironment)this.getEnvironment()).getPropertySources()));
            return excludes.getExclude();
        }
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)this.getEnvironment(), "spring.autoconfigure.");
        String[] exclude = (String[])resolver.getProperty("exclude", String[].class);
        return Arrays.asList(exclude == null ? new String[]{} : exclude);
    }

    private List<String> sort(List<String> configurations) throws IOException {
        configurations = new AutoConfigurationSorter(this.getResourceLoader()).getInPriorityOrder(configurations);
        return configurations;
    }

    private void recordWithConditionEvaluationReport(List<String> configurations, Collection<String> exclusions) throws IOException {
        ConditionEvaluationReport report = ConditionEvaluationReport.get(this.getBeanFactory());
        report.recordEvaluationCandidates(configurations);
        report.recordExclusions(exclusions);
    }

    protected final <T> List<T> removeDuplicates(List<T> list) {
        return new ArrayList<T>(new LinkedHashSet<T>(list));
    }

    protected final List<String> asList(AnnotationAttributes attributes, String name) {
        String[] value = attributes.getStringArray(name);
        return Arrays.asList(value == null ? new String[]{} : value);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected final ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    static class Excludes {
        private List<String> exclude = new ArrayList<String>();

        Excludes() {
        }

        public List<String> getExclude() {
            return this.exclude;
        }

        public void setExclude(List<String> excludes) {
            this.exclude = excludes;
        }
    }
}

