/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum EmbeddedDatabaseConnection {
    NONE(null, null, null),
    H2(EmbeddedDatabaseType.H2, "org.h2.Driver", "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE"),
    DERBY(EmbeddedDatabaseType.DERBY, "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:memory:%s;create=true"),
    HSQL(EmbeddedDatabaseType.HSQL, "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:%s");

    private static final String DEFAULT_DATABASE_NAME = "testdb";
    private final EmbeddedDatabaseType type;
    private final String driverClass;
    private final String url;
    static EmbeddedDatabaseConnection override;

    private EmbeddedDatabaseConnection(EmbeddedDatabaseType type, String driverClass, String url) {
        this.type = type;
        this.driverClass = driverClass;
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClass;
    }

    public EmbeddedDatabaseType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.getUrl(DEFAULT_DATABASE_NAME);
    }

    public String getUrl(String databaseName) {
        Assert.hasText((String)databaseName, (String)"DatabaseName must not be null.");
        return this.url != null ? String.format(this.url, databaseName) : null;
    }

    public static boolean isEmbedded(String driverClass) {
        return driverClass != null && (driverClass.equals(EmbeddedDatabaseConnection.HSQL.driverClass) || driverClass.equals(EmbeddedDatabaseConnection.H2.driverClass) || driverClass.equals(EmbeddedDatabaseConnection.DERBY.driverClass));
    }

    public static boolean isEmbedded(DataSource dataSource) {
        try {
            return (Boolean)new JdbcTemplate(dataSource).execute((ConnectionCallback)new IsEmbedded());
        }
        catch (DataAccessException ex) {
            return false;
        }
    }

    public static EmbeddedDatabaseConnection get(ClassLoader classLoader) {
        if (override != null) {
            return override;
        }
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE || !ClassUtils.isPresent((String)candidate.getDriverClassName(), (ClassLoader)classLoader)) continue;
            return candidate;
        }
        return NONE;
    }

    private static class IsEmbedded
    implements ConnectionCallback<Boolean> {
        private IsEmbedded() {
        }

        public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
            EmbeddedDatabaseConnection[] candidates;
            String productName = connection.getMetaData().getDatabaseProductName();
            if (productName == null) {
                return false;
            }
            productName = productName.toUpperCase();
            for (EmbeddedDatabaseConnection candidate : candidates = EmbeddedDatabaseConnection.values()) {
                if (candidate == NONE || !productName.contains(candidate.name())) continue;
                return true;
            }
            return false;
        }
    }
}

