/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AbstractDatabaseInitializer;
import org.springframework.boot.autoconfigure.DatabaseInitializationMode;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class BatchDatabaseInitializer
extends AbstractDatabaseInitializer {
    private final BatchProperties properties;

    public BatchDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader, BatchProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull((Object)properties, (String)"BatchProperties must not be null");
        this.properties = properties;
    }

    @Override
    protected DatabaseInitializationMode getMode() {
        return this.properties.getInitializeSchema();
    }

    @Override
    protected String getSchemaLocation() {
        return this.properties.getSchema();
    }

    @Override
    protected String getDatabaseName() {
        String databaseName = super.getDatabaseName();
        if ("oracle".equals(databaseName)) {
            return "oracle10g";
        }
        return databaseName;
    }
}

