/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.Environment;

public class MongoClientFactory {
    private final MongoProperties properties;
    private final Environment environment;

    public MongoClientFactory(MongoProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }

    public MongoClient createMongoClient(MongoClientOptions options) {
        Integer embeddedPort = this.getEmbeddedPort();
        if (embeddedPort != null) {
            return this.createEmbeddedMongoClient(options, embeddedPort);
        }
        return this.createNetworkMongoClient(options);
    }

    private Integer getEmbeddedPort() {
        String localPort;
        if (this.environment != null && (localPort = this.environment.getProperty("local.mongo.port")) != null) {
            return Integer.valueOf(localPort);
        }
        return null;
    }

    private MongoClient createEmbeddedMongoClient(MongoClientOptions options, int port) {
        if (options == null) {
            options = MongoClientOptions.builder().build();
        }
        String host = this.properties.getHost() == null ? "localhost" : this.properties.getHost();
        return new MongoClient(Collections.singletonList(new ServerAddress(host, port)), Collections.emptyList(), options);
    }

    private MongoClient createNetworkMongoClient(MongoClientOptions options) {
        if (this.hasCustomAddress() || this.hasCustomCredentials()) {
            if (this.properties.getUri() != null) {
                throw new IllegalStateException("Invalid mongo configuration, either uri or host/port/credentials must be specified");
            }
            if (options == null) {
                options = MongoClientOptions.builder().build();
            }
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            if (this.hasCustomCredentials()) {
                String database = this.properties.getAuthenticationDatabase() == null ? this.properties.getMongoClientDatabase() : this.properties.getAuthenticationDatabase();
                credentials.add(MongoCredential.createCredential((String)this.properties.getUsername(), (String)database, (char[])this.properties.getPassword()));
            }
            String host = this.properties.getHost() == null ? "localhost" : this.properties.getHost();
            int port = this.properties.getPort() != null ? this.properties.getPort() : 27017;
            return new MongoClient(Collections.singletonList(new ServerAddress(host, port)), credentials, options);
        }
        return new MongoClient(new MongoClientURI(this.properties.determineUri(), this.builder(options)));
    }

    private boolean hasCustomAddress() {
        return this.properties.getHost() != null || this.properties.getPort() != null;
    }

    private boolean hasCustomCredentials() {
        return this.properties.getUsername() != null && this.properties.getPassword() != null;
    }

    private MongoClientOptions.Builder builder(MongoClientOptions options) {
        if (options != null) {
            return MongoClientOptions.builder((MongoClientOptions)options);
        }
        return MongoClientOptions.builder();
    }
}

