/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.web.servlet.view.MustacheViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class MustacheServletWebConfiguration {
    private final MustacheProperties mustache;

    protected MustacheServletWebConfiguration(MustacheProperties mustache) {
        this.mustache = mustache;
    }

    @Bean
    @ConditionalOnMissingBean(value={MustacheViewResolver.class})
    public MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler) {
        MustacheViewResolver resolver = new MustacheViewResolver(mustacheCompiler);
        this.mustache.applyToViewResolver(resolver);
        resolver.setCharset(this.mustache.getCharsetName());
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

