/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.quartz;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AbstractDatabaseInitializer;
import org.springframework.boot.autoconfigure.DatabaseInitializationMode;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class QuartzDatabaseInitializer
extends AbstractDatabaseInitializer {
    private final QuartzProperties properties;

    public QuartzDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader, QuartzProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull((Object)properties, (String)"QuartzProperties must not be null");
        this.properties = properties;
    }

    @Override
    protected DatabaseInitializationMode getMode() {
        return this.properties.getJdbc().getInitializeSchema();
    }

    @Override
    protected String getSchemaLocation() {
        return this.properties.getJdbc().getSchema();
    }

    @Override
    protected String getDatabaseName() {
        String databaseName = super.getDatabaseName();
        if ("db2".equals(databaseName)) {
            return "db2_v95";
        }
        if ("mysql".equals(databaseName)) {
            return "mysql_innodb";
        }
        if ("postgresql".equals(databaseName)) {
            return "postgres";
        }
        if ("sqlserver".equals(databaseName)) {
            return "sqlServer";
        }
        return databaseName;
    }
}

