/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={ResourceServerCondition.class})
@ConditionalOnClass(value={EnableResourceServer.class, SecurityProperties.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={ResourceServerConfiguration.class})
@Import(value={ResourceServerTokenServicesConfiguration.class})
public class OAuth2ResourceServerConfiguration {
    private final ResourceServerProperties resource;

    public OAuth2ResourceServerConfiguration(ResourceServerProperties resource) {
        this.resource = resource;
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceServerConfigurer.class})
    public ResourceServerConfigurer resourceServer() {
        return new ResourceSecurityConfigurer(this.resource);
    }

    @ConditionalOnBean(value={AuthorizationServerEndpointsConfiguration.class})
    private static class AuthorizationServerEndpointsConfigurationBeanCondition {
        private AuthorizationServerEndpointsConfigurationBeanCondition() {
        }

        public static boolean matches(ConditionContext context) {
            Class<AuthorizationServerEndpointsConfigurationBeanCondition> type = AuthorizationServerEndpointsConfigurationBeanCondition.class;
            Conditional conditional = (Conditional)AnnotationUtils.findAnnotation(type, Conditional.class);
            StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(type);
            for (Class conditionType : conditional.value()) {
                Condition condition = (Condition)BeanUtils.instantiateClass((Class)conditionType);
                if (!condition.matches(context, (AnnotatedTypeMetadata)metadata)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ResourceServerCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        private static final Bindable<Map<String, Object>> STRING_OBJECT_MAP = Bindable.mapOf(String.class, Object.class);
        private static final String AUTHORIZATION_ANNOTATION = "org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration";

        protected ResourceServerCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String prefix;
            ConditionMessage.Builder message = ConditionMessage.forCondition("OAuth ResourceServer Condition", new Object[0]);
            Environment environment = context.getEnvironment();
            if (!(environment instanceof ConfigurableEnvironment)) {
                return ConditionOutcome.noMatch(message.didNotFind("A ConfigurableEnvironment").atAll());
            }
            if (this.hasOAuthClientId(environment)) {
                return ConditionOutcome.match(message.foundExactly("client-id property"));
            }
            Binder binder = Binder.get((Environment)environment);
            if (binder.bind((prefix = "security.oauth2.resource.") + "jwt", STRING_OBJECT_MAP).isBound()) {
                return ConditionOutcome.match(message.foundExactly("JWT resource configuration"));
            }
            if (binder.bind(prefix + "jwk", STRING_OBJECT_MAP).isBound()) {
                return ConditionOutcome.match(message.foundExactly("JWK resource configuration"));
            }
            if (StringUtils.hasText((String)environment.getProperty(prefix + "user-info-uri"))) {
                return ConditionOutcome.match(message.foundExactly("user-info-uri property"));
            }
            if (StringUtils.hasText((String)environment.getProperty(prefix + "token-info-uri"))) {
                return ConditionOutcome.match(message.foundExactly("token-info-uri property"));
            }
            if (ClassUtils.isPresent((String)AUTHORIZATION_ANNOTATION, null) && AuthorizationServerEndpointsConfigurationBeanCondition.matches(context)) {
                return ConditionOutcome.match(message.found("class").items(AUTHORIZATION_ANNOTATION));
            }
            return ConditionOutcome.noMatch(message.didNotFind("client ID, JWT resource or authorization server").atAll());
        }

        private boolean hasOAuthClientId(Environment environment) {
            return StringUtils.hasLength((String)environment.getProperty("security.oauth2.client.client-id"));
        }
    }

    protected static class ResourceSecurityConfigurer
    extends ResourceServerConfigurerAdapter {
        private ResourceServerProperties resource;

        public ResourceSecurityConfigurer(ResourceServerProperties resource) {
            this.resource = resource;
        }

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            resources.resourceId(this.resource.getResourceId());
        }

        public void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
    }
}

