/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnBootstrapHostsCondition
extends SpringBootCondition {
    private static final Bindable<List<String>> STRING_LIST = Bindable.listOf(String.class);

    OnBootstrapHostsCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String name = "spring.couchbase.bootstrap-hosts";
        BindResult property = Binder.get((Environment)context.getEnvironment()).bind(name, STRING_LIST);
        if (property.isBound()) {
            return ConditionOutcome.match(ConditionMessage.forCondition(OnBootstrapHostsCondition.class.getName(), new Object[0]).found("property").items(name));
        }
        return ConditionOutcome.noMatch(ConditionMessage.forCondition(OnBootstrapHostsCondition.class.getName(), new Object[0]).didNotFind("property").items(name));
    }
}

