/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.integration.IntegrationProperties;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;

public class IntegrationDataSourceScriptDatabaseInitializer
extends DataSourceScriptDatabaseInitializer {
    public IntegrationDataSourceScriptDatabaseInitializer(DataSource dataSource, IntegrationProperties.Jdbc properties) {
        this(dataSource, IntegrationDataSourceScriptDatabaseInitializer.getSettings(dataSource, properties));
    }

    public IntegrationDataSourceScriptDatabaseInitializer(DataSource dataSource, DatabaseInitializationSettings settings) {
        super(dataSource, settings);
    }

    static DatabaseInitializationSettings getSettings(DataSource dataSource, IntegrationProperties.Jdbc properties) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        settings.setSchemaLocations(platformResolver.resolveAll(dataSource, new String[]{properties.getSchema()}));
        settings.setMode(properties.getInitializeSchema());
        settings.setContinueOnError(true);
        return settings;
    }
}

